#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 Hoël Bézier <hoelbezier@riseup.net>
set -o errexit

###
# The Count Lucanor
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250407.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='the-count-lucanor'
GAME_NAME='The Count Lucanor'

ARCHIVE_BASE_1_NAME='the_count_lucanor_1_4_23_36418.sh'
ARCHIVE_BASE_1_MD5='59bdd0ee4d7525be7b5ba346ffefa5b9'
ARCHIVE_BASE_1_SIZE='760000'
ARCHIVE_BASE_1_VERSION='1.4.23-gog36418'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_count_lucanor'

ARCHIVE_BASE_0_NAME='the_count_lucanor_1_1_4_7_23841.sh'
ARCHIVE_BASE_0_MD5='5a224a28d6e1a3b894e712db056fab07'
ARCHIVE_BASE_0_SIZE='720000'
ARCHIVE_BASE_0_VERSION='1.1.4.7-gog23841'

CONTENT_GAME_MAIN_DEPENDENCIES_LIBRARIES='
libopenal.so.1
libSDL-1.2.so.0'
## TODO: Check if the dependency on libva.so.1 is actually required
CONTENT_GAME_MAIN_DEPENDENCIES_LIBRARIES="${CONTENT_GAME_MAIN_DEPENDENCIES_LIBRARIES:-}
libva.so.1"
CONTENT_GAME_MAIN_ARCH='64'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_MAIN_RELATIVE_PATH='lib'
CONTENT_LIBS_MAIN_FILES='
libavcodec.so.56
libavdevice.so.56
libavfilter.so.5
libavformat.so.56
libavresample.so.2
libavutil.so.54
libgluegen-rt.so
libjinput-linux64.so
libjoal.so
libjogl_desktop.so
libjogl_mobile.so
libnativewindow_awt.so
libnativewindow_x11.so
libnewt.so
libswresample.so.1
libswscale.so.3
libvpx.so.2'
## TODO: Check if the Steam libraries can be dropped
CONTENT_LIBS_MAIN_FILES="${CONTENT_LIBS_MAIN_FILES:-}
libsteam_api64.so
libsteamworks4j64.so"
CONTENT_GAME_MAIN_FILES='
res
lucanor.ico
lib/*.jar'

USER_PERSISTENT_DIRECTORIES='
logs
res/db
res/level
res/settings'

APP_MAIN_TYPE='java'
APP_MAIN_JAVA_OPTIONS='-Dfile.encoding=UTF-8 -Xmx1024m -Xms512m'
APP_MAIN_EXE='lib/build-desktop.jar'
APP_MAIN_ICON='lucanor.ico'
## Prevent an OpenGL-related crash on launch:
##
## com.jogamp.opengl.GLException: Profile GL2 is not available on null, but: [GLProfile[GLES1/GLES1.hw], GLProfile[GLES2/GLES3.hw], GLProfile[GL2ES1/GLES1.hw], GLProfile[GL4ES3/GL4.hw], GLProfile[GL2ES2/GL4.hw], GLProfile[GL4/GL4.hw], GLProfile[GLES3/GLES3.hw], GLProfile[GL4/GL4.hw], GLProfile[GL3/GL4.hw], GLProfile[GL2GL3/GL4.hw]]
##         at com.jogamp.opengl.GLProfile.get(GLProfile.java:991)
##         at com.jogamp.opengl.GLProfile.get(GLProfile.java:1004)
##         at eu.curvedcat.game.Main.launch(Main.java:669)
##         at eu.curvedcat.game.Main.main(Main.java:611)
APP_MAIN_PRERUN='
# Prevent an OpenGL-related crash on launch
export MESA_GL_VERSION_OVERRIDE=2.1'

# Load common functions

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

pkg_setup() {
	PKG_MAIN_DEPENDENCIES_LIBRARIES="$CONTENT_GAME_MAIN_DEPENDENCIES_LIBRARIES"
	PKG_MAIN_ARCH="$CONTENT_GAME_MAIN_ARCH"
}

src_extract() {
	archive_extraction_default
}

src_prepare() {
	:
}

pkg_prepare() {
	content_inclusion_default
}

src_clean() {
	:
}

pkg_icons() {
	content_inclusion_icons
}

pkg_launchers() {
	launchers_generation
}

pkg_build() {
	packages_generation
}

pkg_clean() {
	working_directory_cleanup
}

pkg_instructions() {
	print_instructions
}

# Run the default initialization actions
initialization_default "$@"

pkg_setup
src_extract
src_prepare
pkg_icons ## pkg_icons must be called before pkg_prepare
pkg_prepare
src_clean
pkg_launchers
pkg_build
pkg_instructions
pkg_clean ## pkg_clean must be called after pkg_instructions

exit 0
