//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.
#include <QDirIterator>
void acetoneiso::wma2wav()
{

QDir Home = QDir::home();
QString dacomprimere = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select WMA Audio File"), Home.path(), tr("Audio WMA (*.wma)"));
if (!dacomprimere.isEmpty() ) {
         QFileInfo fi(dacomprimere);
        QString filenopath = fi.fileName();
		filenopath.chop(4);
   QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save MP3"),
       filenopath,tr("Audio MP3 (*.mp3)"));
if ( fileName.isNull() ) {
   }
else {

   QString wav;
   wav = fileName.append(".wav");

QString alog( QDir::home().path() + "/.acetoneiso/acetoneiso.log" );
//file di log
QFile log( alog );
AUdio.setReadChannel(QProcess::StandardOutput);//imposto il canale di lettura del processo
AUdio.setStandardOutputFile( alog,   QIODevice::Truncate );//l'output di va nel file alog
AUdio.start("ffmpeg",QStringList() <<  "-i" << dacomprimere << wav );
progBarra();
//qDebug() << "FINISCO WMA2WAV E ASPETTO IL SEGNALE";
while( !AUdio.waitForFinished() ){
   return;   
   } //fine while
   wavmp3( fileName, wav );
  }  //fine else
 }   //fine primo if
}    //fine funzione

void acetoneiso::wavmp3( QString str1, QString str2 )
{

QString mp3;
mp3 = str1.append(".mp3");
AUdio.start("lame",QStringList() << str2 << mp3 );
progBarra();
	QFile wavfile (str2);
	wavfile.remove();

}


//rippa cd audio
//TODO: ricorsivamente deve convertirli in MP3
void acetoneiso::ripcdaudio()
{
QDir Home = QDir::home();
QString folder = QFileDialog::getExistingDirectory(this, tr("AcetoneISO::Select where to Save ripped CD-Audio"),Home.path());

if (folder.isNull() ) {
return;
}
else {
        RIpaudio.setWorkingDirectory( folder );
        RIpaudio.start("cdparanoia",QStringList() <<  "-B" );
        progBarra();

     /*   QDirIterator it(folder, QDirIterator::Subdirectories);
         while (it.filePath()) {
             qDebug() << it.next();


         }
*/
}
}




//extract audio file from any video, pure 100% copy of audio including audio codec
void acetoneiso::extractaudio()
{
QDir bin("/usr/bin");
QFile rar;
QDir::setCurrent( bin.path() );
rar.setFileName("ffmpeg");
if (!rar.exists()) {  
 QMessageBox::critical(this, "AcetoneISO",tr("Unable to find") + " ffmpeg " + tr("in /usr/bin.\nPlease install it and be sure it's linked to /usr/bin folder.") );
return;
} 
  
QDir Home = QDir::home();
QString dacomprimere = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Video File"), Home.path(), tr("Video (*.avi *.mpg *.mpeg *.wmv *.flv *.mov *.asf *.rm *.mp4)"));
if (!dacomprimere.isEmpty() ) {
         QFileInfo fi(dacomprimere);
        QString filenopath = fi.fileName();
		filenopath.chop(4);
   QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save WAV"),
       filenopath,tr("Audio WAV (*.wav)"));
if ( fileName.isNull() ) {
   }
else {

   QString wav;
   wav = fileName.append(".wav");

	 showProgressDisplay();
	 extractaudiofromvideo = new QProcess();
	 extractaudiofromvideo->setReadChannel(QProcess::StandardOutput);
	 extractaudiofromvideo->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(extractaudiofromvideo, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_extractaudiofromvideo() )); 
    connect( extractaudiofromvideo, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutextractaudiofromvideo(int, QProcess::ExitStatus)));	   
//ffmpeg -i mandelbrot.flv -vn -acodec pcm_s16le -ar 44100 -ac 2 mandelbrot.wav
extractaudiofromvideo->start("ffmpeg",QStringList() <<  "-i" << dacomprimere  << "-vn" << "-acodec" << "pcm_s16le" << "-ar" << "44100" << "-ac" << "2" << wav );

}
}
}

//extract audio file from any video, pure 100% copy of audio including audio codec
void acetoneiso::wav2mp3()
{

QDir Home = QDir::home();
QString dacomprimere = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Wav File"), Home.path(), tr("WAV (*.wav)"));
if (!dacomprimere.isEmpty() ) {
         QFileInfo fi(dacomprimere);
        QString filenopath = fi.fileName();
		filenopath.chop(4);
   QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save MP3"),
       filenopath,tr("Audio MP3 (*.mp3)"));
if ( fileName.isNull() ) {
   }
else {

   QString wav;
   wav = fileName.append(".mp3");

QString alog( QDir::home().path() + "/.acetoneiso/acetoneiso.log" );
//file di log
QFile log( alog );
AUdio.setReadChannel(QProcess::StandardOutput);//imposto il canale di lettura del processo
AUdio.setStandardOutputFile( alog,   QIODevice::Truncate );//l'output di va nel file alog
AUdio.start("lame",QStringList() << dacomprimere  << wav );
progBarra();
}
}
}


//messaggi output
void acetoneiso::printOutaudiotools(int, QProcess::ExitStatus)
	{
	    QMainWindow::showNormal();
	int valore_uscita = AUdio.exitCode();
	if( valore_uscita == 0 )
	QMessageBox::information(this, "AcetoneISO",tr("Process Succesfully Finished!"));
	else
	QMessageBox::critical(this, "AcetoneISO","Process Error Code: " + QString::number(valore_uscita) + tr("\nPlease see the log file in   ") + QDir::home().path() + ("/.acetoneiso/acetoneiso.log"));
	}

void acetoneiso::printOutripaudio(int, QProcess::ExitStatus)
	{
	    QMainWindow::showNormal();
	int valore_uscita = RIpaudio.exitCode();
	if( valore_uscita == 0 )
	QMessageBox::information(this, "AcetoneISO",tr("Process Succesfully Finished!"));
	else
	QMessageBox::critical(this, "AcetoneISO","Process Error Code: " + QString::number(valore_uscita) );
	}



