# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class EnvironmentDetails(_serialization.Model):
    """The environment details of the resource.

    :ivar native_resource_id: The native resource id of the resource (in case of Azure - the
     resource Id, in case of MC - the native resource id).
    :vartype native_resource_id: str
    :ivar environment_hierarchy_id: The hierarchy id of the connector (in case of Azure - the
     subscription Id, in case of MC - the hierarchyId id).
    :vartype environment_hierarchy_id: str
    :ivar organizational_hierarchy_id: The organizational hierarchy id of the connector (in case of
     Azure - the subscription Id, in case of MC - the organizational hierarchyId id).
    :vartype organizational_hierarchy_id: str
    :ivar subscription_id: The subscription Id.
    :vartype subscription_id: str
    :ivar tenant_id: The tenant Id.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "native_resource_id": {"key": "nativeResourceId", "type": "str"},
        "environment_hierarchy_id": {"key": "environmentHierarchyId", "type": "str"},
        "organizational_hierarchy_id": {"key": "organizationalHierarchyId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        native_resource_id: Optional[str] = None,
        environment_hierarchy_id: Optional[str] = None,
        organizational_hierarchy_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_resource_id: The native resource id of the resource (in case of Azure - the
         resource Id, in case of MC - the native resource id).
        :paramtype native_resource_id: str
        :keyword environment_hierarchy_id: The hierarchy id of the connector (in case of Azure - the
         subscription Id, in case of MC - the hierarchyId id).
        :paramtype environment_hierarchy_id: str
        :keyword organizational_hierarchy_id: The organizational hierarchy id of the connector (in case
         of Azure - the subscription Id, in case of MC - the organizational hierarchyId id).
        :paramtype organizational_hierarchy_id: str
        :keyword subscription_id: The subscription Id.
        :paramtype subscription_id: str
        :keyword tenant_id: The tenant Id.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.native_resource_id = native_resource_id
        self.environment_hierarchy_id = environment_hierarchy_id
        self.organizational_hierarchy_id = organizational_hierarchy_id
        self.subscription_id = subscription_id
        self.tenant_id = tenant_id


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2023_05_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2023_05_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.security.v2023_05_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.security.v2023_05_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class HealthDataClassification(_serialization.Model):
    """The classification of the health report.

    :ivar component: The component describes the name of the agent/service that scans the issue.
    :vartype component: str
    :ivar scenario: The scenario describes the health scenario issue of the component.
    :vartype scenario: str
    :ivar scope: The resource scope of the health report.
    :vartype scope: str
    """

    _attribute_map = {
        "component": {"key": "component", "type": "str"},
        "scenario": {"key": "scenario", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        component: Optional[str] = None,
        scenario: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component: The component describes the name of the agent/service that scans the issue.
        :paramtype component: str
        :keyword scenario: The scenario describes the health scenario issue of the component.
        :paramtype scenario: str
        :keyword scope: The resource scope of the health report.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.component = component
        self.scenario = scenario
        self.scope = scope


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class HealthReport(Resource):  # pylint: disable=too-many-instance-attributes
    """The health report resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_details: The resource details of the health report.
    :vartype resource_details: ~azure.mgmt.security.v2023_05_01_preview.models.ResourceDetails
    :ivar environment_details: The environment details of the resource.
    :vartype environment_details:
     ~azure.mgmt.security.v2023_05_01_preview.models.EnvironmentDetails
    :ivar health_data_classification: The classification of the health report.
    :vartype health_data_classification:
     ~azure.mgmt.security.v2023_05_01_preview.models.HealthDataClassification
    :ivar status: The status of the health report.
    :vartype status: ~azure.mgmt.security.v2023_05_01_preview.models.Status
    :ivar affected_defenders_plans: The affected defenders plans by unhealthy report.
    :vartype affected_defenders_plans: list[str]
    :ivar affected_defenders_sub_plans: The affected defenders sub plans by unhealthy report.
    :vartype affected_defenders_sub_plans: list[str]
    :ivar report_additional_data: Additional data for the given health report, this field can
     include more details on the resource and the health scenario.
    :vartype report_additional_data: dict[str, str]
    :ivar issues: A collection of the issues in the report.
    :vartype issues: list[~azure.mgmt.security.v2023_05_01_preview.models.Issue]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "report_additional_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "environment_details": {"key": "properties.environmentDetails", "type": "EnvironmentDetails"},
        "health_data_classification": {
            "key": "properties.healthDataClassification",
            "type": "HealthDataClassification",
        },
        "status": {"key": "properties.status", "type": "Status"},
        "affected_defenders_plans": {"key": "properties.affectedDefendersPlans", "type": "[str]"},
        "affected_defenders_sub_plans": {"key": "properties.affectedDefendersSubPlans", "type": "[str]"},
        "report_additional_data": {"key": "properties.reportAdditionalData", "type": "{str}"},
        "issues": {"key": "properties.issues", "type": "[Issue]"},
    }

    def __init__(
        self,
        *,
        resource_details: Optional["_models.ResourceDetails"] = None,
        environment_details: Optional["_models.EnvironmentDetails"] = None,
        health_data_classification: Optional["_models.HealthDataClassification"] = None,
        status: Optional["_models.Status"] = None,
        affected_defenders_plans: Optional[List[str]] = None,
        affected_defenders_sub_plans: Optional[List[str]] = None,
        issues: Optional[List["_models.Issue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: The resource details of the health report.
        :paramtype resource_details: ~azure.mgmt.security.v2023_05_01_preview.models.ResourceDetails
        :keyword environment_details: The environment details of the resource.
        :paramtype environment_details:
         ~azure.mgmt.security.v2023_05_01_preview.models.EnvironmentDetails
        :keyword health_data_classification: The classification of the health report.
        :paramtype health_data_classification:
         ~azure.mgmt.security.v2023_05_01_preview.models.HealthDataClassification
        :keyword status: The status of the health report.
        :paramtype status: ~azure.mgmt.security.v2023_05_01_preview.models.Status
        :keyword affected_defenders_plans: The affected defenders plans by unhealthy report.
        :paramtype affected_defenders_plans: list[str]
        :keyword affected_defenders_sub_plans: The affected defenders sub plans by unhealthy report.
        :paramtype affected_defenders_sub_plans: list[str]
        :keyword issues: A collection of the issues in the report.
        :paramtype issues: list[~azure.mgmt.security.v2023_05_01_preview.models.Issue]
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.environment_details = environment_details
        self.health_data_classification = health_data_classification
        self.status = status
        self.affected_defenders_plans = affected_defenders_plans
        self.affected_defenders_sub_plans = affected_defenders_sub_plans
        self.report_additional_data = None
        self.issues = issues


class HealthReportsList(_serialization.Model):
    """Page of health reports list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of health reports in this page.
    :vartype value: list[~azure.mgmt.security.v2023_05_01_preview.models.HealthReport]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HealthReport]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Issue(_serialization.Model):
    """The issue that caused the resource to by unhealthy.

    All required parameters must be populated in order to send to server.

    :ivar issue_key: The unique issue key. Required.
    :vartype issue_key: str
    :ivar issue_name: The issue name.
    :vartype issue_name: str
    :ivar security_values: The affected security values that MDC offers that will be affected by
     the issue, for example: recommendations, alerts, etc.
    :vartype security_values: list[str]
    :ivar issue_description: The issue description.
    :vartype issue_description: str
    :ivar remediation_steps: Human readable description of what you should do to mitigate this
     health issue.
    :vartype remediation_steps: str
    :ivar remediation_script: The remediation script to solve this issue.
    :vartype remediation_script: str
    :ivar issue_additional_data: Additional data for the given issue. The additional data depends
     on the issue type.
    :vartype issue_additional_data: dict[str, str]
    """

    _validation = {
        "issue_key": {"required": True},
    }

    _attribute_map = {
        "issue_key": {"key": "issueKey", "type": "str"},
        "issue_name": {"key": "issueName", "type": "str"},
        "security_values": {"key": "securityValues", "type": "[str]"},
        "issue_description": {"key": "issueDescription", "type": "str"},
        "remediation_steps": {"key": "remediationSteps", "type": "str"},
        "remediation_script": {"key": "remediationScript", "type": "str"},
        "issue_additional_data": {"key": "issueAdditionalData", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        issue_key: str,
        issue_name: Optional[str] = None,
        security_values: Optional[List[str]] = None,
        issue_description: Optional[str] = None,
        remediation_steps: Optional[str] = None,
        remediation_script: Optional[str] = None,
        issue_additional_data: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword issue_key: The unique issue key. Required.
        :paramtype issue_key: str
        :keyword issue_name: The issue name.
        :paramtype issue_name: str
        :keyword security_values: The affected security values that MDC offers that will be affected by
         the issue, for example: recommendations, alerts, etc.
        :paramtype security_values: list[str]
        :keyword issue_description: The issue description.
        :paramtype issue_description: str
        :keyword remediation_steps: Human readable description of what you should do to mitigate this
         health issue.
        :paramtype remediation_steps: str
        :keyword remediation_script: The remediation script to solve this issue.
        :paramtype remediation_script: str
        :keyword issue_additional_data: Additional data for the given issue. The additional data
         depends on the issue type.
        :paramtype issue_additional_data: dict[str, str]
        """
        super().__init__(**kwargs)
        self.issue_key = issue_key
        self.issue_name = issue_name
        self.security_values = security_values
        self.issue_description = issue_description
        self.remediation_steps = remediation_steps
        self.remediation_script = remediation_script
        self.issue_additional_data = issue_additional_data


class ResourceDetails(_serialization.Model):
    """The resource details of the health report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source: The status of the health report. Known values are: "Aws", "Gcp", and "Azure".
    :vartype source: str or ~azure.mgmt.security.v2023_05_01_preview.models.Source
    :ivar id: The azure id of the resource.
    :vartype id: str
    :ivar connector_id: The id of the connector.
    :vartype connector_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "connector_id": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "connector_id": {"key": "connectorId", "type": "str"},
    }

    def __init__(self, *, source: Optional[Union[str, "_models.Source"]] = None, **kwargs: Any) -> None:
        """
        :keyword source: The status of the health report. Known values are: "Aws", "Gcp", and "Azure".
        :paramtype source: str or ~azure.mgmt.security.v2023_05_01_preview.models.Source
        """
        super().__init__(**kwargs)
        self.source = source
        self.id = None
        self.connector_id = None


class Status(_serialization.Model):
    """The status of the health report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status of the health report. Known values are: "Healthy", "NotHealthy", and
     "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.v2023_05_01_preview.models.StatusName
    :ivar reason: The reason of the given status.
    :vartype reason: str
    :ivar last_scanned_date: The date of when the resource was scanned in the last time.
    :vartype last_scanned_date: ~datetime.datetime
    :ivar status_change_date: The date of when the status of the health report was changed in the
     last time.
    :vartype status_change_date: ~datetime.datetime
    :ivar first_evaluation_date: The date of when the resource of the health report was scanned in
     the first time.
    :vartype first_evaluation_date: ~datetime.datetime
    """

    _validation = {
        "reason": {"readonly": True},
        "last_scanned_date": {"readonly": True},
        "status_change_date": {"readonly": True},
        "first_evaluation_date": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "last_scanned_date": {"key": "lastScannedDate", "type": "iso-8601"},
        "status_change_date": {"key": "statusChangeDate", "type": "iso-8601"},
        "first_evaluation_date": {"key": "firstEvaluationDate", "type": "iso-8601"},
    }

    def __init__(self, *, code: Optional[Union[str, "_models.StatusName"]] = None, **kwargs: Any) -> None:
        """
        :keyword code: The status of the health report. Known values are: "Healthy", "NotHealthy", and
         "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.v2023_05_01_preview.models.StatusName
        """
        super().__init__(**kwargs)
        self.code = code
        self.reason = None
        self.last_scanned_date = None
        self.status_change_date = None
        self.first_evaluation_date = None
