# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class Api(ProxyResource):
    """API entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.ApiProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApiProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ApiProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.ApiProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ApiDefinition(ProxyResource):
    """API definition entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.ApiDefinitionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApiDefinitionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ApiDefinitionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.ApiDefinitionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ApiDefinitionListResult(_serialization.Model):
    """The response of a ApiDefinition list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The ApiDefinition items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.ApiDefinition]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ApiDefinitionProperties(_serialization.Model):
    """API definition properties entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar title: API definition title. Required.
    :vartype title: str
    :ivar description: API definition description.
    :vartype description: str
    :ivar specification: API specification details.
    :vartype specification: ~azure.mgmt.apicenter.models.ApiDefinitionPropertiesSpecification
    """

    _validation = {
        "title": {"required": True, "max_length": 50, "min_length": 1},
        "specification": {"readonly": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "specification": {"key": "specification", "type": "ApiDefinitionPropertiesSpecification"},
    }

    def __init__(self, *, title: str, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword title: API definition title. Required.
        :paramtype title: str
        :keyword description: API definition description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.specification = None


class ApiDefinitionPropertiesSpecification(_serialization.Model):
    """API specification details.

    :ivar name: Specification name.
    :vartype name: str
    :ivar version: Specification version.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Specification name.
        :paramtype name: str
        :keyword version: Specification version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.version = version


class ApiListResult(_serialization.Model):
    """The response of a Api list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Api items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.Api]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Api]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ApiProperties(_serialization.Model):
    """API properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar title: API title. Required.
    :vartype title: str
    :ivar kind: Kind of API. For example, REST or GraphQL. Required. Known values are: "rest",
     "graphql", "grpc", "soap", "webhook", and "websocket".
    :vartype kind: str or ~azure.mgmt.apicenter.models.ApiKind
    :ivar description: Description of the API.
    :vartype description: str
    :ivar summary: Short description of the API.
    :vartype summary: str
    :ivar lifecycle_stage: Current lifecycle stage of the API. Known values are: "design",
     "development", "testing", "preview", "production", "deprecated", and "retired".
    :vartype lifecycle_stage: str or ~azure.mgmt.apicenter.models.LifecycleStage
    :ivar terms_of_service: Terms of service for the API.
    :vartype terms_of_service: ~azure.mgmt.apicenter.models.TermsOfService
    :ivar external_documentation: The set of external documentation.
    :vartype external_documentation: list[~azure.mgmt.apicenter.models.ExternalDocumentation]
    :ivar contacts: The set of contacts.
    :vartype contacts: list[~azure.mgmt.apicenter.models.Contact]
    :ivar license: The license information for the API.
    :vartype license: ~azure.mgmt.apicenter.models.License
    :ivar custom_properties: The custom metadata defined for API catalog entities.
    :vartype custom_properties: JSON
    """

    _validation = {
        "title": {"required": True, "max_length": 50, "min_length": 1},
        "kind": {"required": True},
        "description": {"max_length": 1000},
        "summary": {"max_length": 200},
        "lifecycle_stage": {"readonly": True},
        "external_documentation": {"max_items": 20, "min_items": 0},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "summary": {"key": "summary", "type": "str"},
        "lifecycle_stage": {"key": "lifecycleStage", "type": "str"},
        "terms_of_service": {"key": "termsOfService", "type": "TermsOfService"},
        "external_documentation": {"key": "externalDocumentation", "type": "[ExternalDocumentation]"},
        "contacts": {"key": "contacts", "type": "[Contact]"},
        "license": {"key": "license", "type": "License"},
        "custom_properties": {"key": "customProperties", "type": "object"},
    }

    def __init__(
        self,
        *,
        title: str,
        kind: Union[str, "_models.ApiKind"],
        description: Optional[str] = None,
        summary: Optional[str] = None,
        terms_of_service: Optional["_models.TermsOfService"] = None,
        external_documentation: Optional[List["_models.ExternalDocumentation"]] = None,
        contacts: Optional[List["_models.Contact"]] = None,
        license: Optional["_models.License"] = None,
        custom_properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: API title. Required.
        :paramtype title: str
        :keyword kind: Kind of API. For example, REST or GraphQL. Required. Known values are: "rest",
         "graphql", "grpc", "soap", "webhook", and "websocket".
        :paramtype kind: str or ~azure.mgmt.apicenter.models.ApiKind
        :keyword description: Description of the API.
        :paramtype description: str
        :keyword summary: Short description of the API.
        :paramtype summary: str
        :keyword terms_of_service: Terms of service for the API.
        :paramtype terms_of_service: ~azure.mgmt.apicenter.models.TermsOfService
        :keyword external_documentation: The set of external documentation.
        :paramtype external_documentation: list[~azure.mgmt.apicenter.models.ExternalDocumentation]
        :keyword contacts: The set of contacts.
        :paramtype contacts: list[~azure.mgmt.apicenter.models.Contact]
        :keyword license: The license information for the API.
        :paramtype license: ~azure.mgmt.apicenter.models.License
        :keyword custom_properties: The custom metadata defined for API catalog entities.
        :paramtype custom_properties: JSON
        """
        super().__init__(**kwargs)
        self.title = title
        self.kind = kind
        self.description = description
        self.summary = summary
        self.lifecycle_stage = None
        self.terms_of_service = terms_of_service
        self.external_documentation = external_documentation
        self.contacts = contacts
        self.license = license
        self.custom_properties = custom_properties


class ApiSpecExportResult(_serialization.Model):
    """The API specification export result.

    :ivar format: The format of exported result. Known values are: "inline" and "link".
    :vartype format: str or ~azure.mgmt.apicenter.models.ApiSpecExportResultFormat
    :ivar value: The result of the export operation.
    :vartype value: str
    """

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "_models.ApiSpecExportResultFormat"]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword format: The format of exported result. Known values are: "inline" and "link".
        :paramtype format: str or ~azure.mgmt.apicenter.models.ApiSpecExportResultFormat
        :keyword value: The result of the export operation.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.format = format
        self.value = value


class ApiSpecImportRequest(_serialization.Model):
    """The API specification source entity properties.

    :ivar value: Value of the API specification source.
    :vartype value: str
    :ivar format: Format of the API specification source. Known values are: "inline" and "link".
    :vartype format: str or ~azure.mgmt.apicenter.models.ApiSpecImportSourceFormat
    :ivar specification: API specification details.
    :vartype specification: ~azure.mgmt.apicenter.models.ApiSpecImportRequestSpecification
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "format": {"key": "format", "type": "str"},
        "specification": {"key": "specification", "type": "ApiSpecImportRequestSpecification"},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        format: Optional[Union[str, "_models.ApiSpecImportSourceFormat"]] = None,
        specification: Optional["_models.ApiSpecImportRequestSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Value of the API specification source.
        :paramtype value: str
        :keyword format: Format of the API specification source. Known values are: "inline" and "link".
        :paramtype format: str or ~azure.mgmt.apicenter.models.ApiSpecImportSourceFormat
        :keyword specification: API specification details.
        :paramtype specification: ~azure.mgmt.apicenter.models.ApiSpecImportRequestSpecification
        """
        super().__init__(**kwargs)
        self.value = value
        self.format = format
        self.specification = specification


class ApiSpecImportRequestSpecification(_serialization.Model):
    """API specification details.

    :ivar name: Specification name.
    :vartype name: str
    :ivar version: Specification version.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Specification name.
        :paramtype name: str
        :keyword version: Specification version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.version = version


class ApiVersion(ProxyResource):
    """API version entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.ApiVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ApiVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ApiVersionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.ApiVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ApiVersionListResult(_serialization.Model):
    """The response of a ApiVersion list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The ApiVersion items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.ApiVersion]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ApiVersionProperties(_serialization.Model):
    """API version properties entity.

    All required parameters must be populated in order to send to Azure.

    :ivar title: API version title. Required.
    :vartype title: str
    :ivar lifecycle_stage: Current lifecycle stage of the API. Required. Known values are:
     "design", "development", "testing", "preview", "production", "deprecated", and "retired".
    :vartype lifecycle_stage: str or ~azure.mgmt.apicenter.models.LifecycleStage
    """

    _validation = {
        "title": {"required": True, "max_length": 50, "min_length": 1},
        "lifecycle_stage": {"required": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "lifecycle_stage": {"key": "lifecycleStage", "type": "str"},
    }

    def __init__(self, *, title: str, lifecycle_stage: Union[str, "_models.LifecycleStage"], **kwargs: Any) -> None:
        """
        :keyword title: API version title. Required.
        :paramtype title: str
        :keyword lifecycle_stage: Current lifecycle stage of the API. Required. Known values are:
         "design", "development", "testing", "preview", "production", "deprecated", and "retired".
        :paramtype lifecycle_stage: str or ~azure.mgmt.apicenter.models.LifecycleStage
        """
        super().__init__(**kwargs)
        self.title = title
        self.lifecycle_stage = lifecycle_stage


class Contact(_serialization.Model):
    """Contact information.

    :ivar name: Name of the contact.
    :vartype name: str
    :ivar url: URL for the contact.
    :vartype url: str
    :ivar email: Email address of the contact.
    :vartype email: str
    """

    _validation = {
        "name": {"max_length": 100},
        "url": {"max_length": 200},
        "email": {"max_length": 100},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, url: Optional[str] = None, email: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the contact.
        :paramtype name: str
        :keyword url: URL for the contact.
        :paramtype url: str
        :keyword email: Email address of the contact.
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.url = url
        self.email = email


class Deployment(ProxyResource):
    """API deployment entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.DeploymentProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DeploymentProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeploymentProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.DeploymentProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DeploymentListResult(_serialization.Model):
    """The response of a Deployment list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Deployment items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.Deployment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Deployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class DeploymentProperties(_serialization.Model):
    """API deployment entity properties.

    :ivar title: API deployment title.
    :vartype title: str
    :ivar description: Description of the deployment.
    :vartype description: str
    :ivar environment_id: API center-scoped environment resource ID.
    :vartype environment_id: str
    :ivar definition_id: API center-scoped definition resource ID.
    :vartype definition_id: str
    :ivar state: State of API deployment. Known values are: "active" and "inactive".
    :vartype state: str or ~azure.mgmt.apicenter.models.DeploymentState
    :ivar server: The deployment server.
    :vartype server: ~azure.mgmt.apicenter.models.DeploymentServer
    :ivar custom_properties: The custom metadata defined for API catalog entities.
    :vartype custom_properties: JSON
    """

    _validation = {
        "title": {"max_length": 50, "min_length": 1},
        "description": {"max_length": 500},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "definition_id": {"key": "definitionId", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "server": {"key": "server", "type": "DeploymentServer"},
        "custom_properties": {"key": "customProperties", "type": "object"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        definition_id: Optional[str] = None,
        state: Optional[Union[str, "_models.DeploymentState"]] = None,
        server: Optional["_models.DeploymentServer"] = None,
        custom_properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: API deployment title.
        :paramtype title: str
        :keyword description: Description of the deployment.
        :paramtype description: str
        :keyword environment_id: API center-scoped environment resource ID.
        :paramtype environment_id: str
        :keyword definition_id: API center-scoped definition resource ID.
        :paramtype definition_id: str
        :keyword state: State of API deployment. Known values are: "active" and "inactive".
        :paramtype state: str or ~azure.mgmt.apicenter.models.DeploymentState
        :keyword server: The deployment server.
        :paramtype server: ~azure.mgmt.apicenter.models.DeploymentServer
        :keyword custom_properties: The custom metadata defined for API catalog entities.
        :paramtype custom_properties: JSON
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.environment_id = environment_id
        self.definition_id = definition_id
        self.state = state
        self.server = server
        self.custom_properties = custom_properties


class DeploymentServer(_serialization.Model):
    """Server.

    :ivar runtime_uri: Base runtime URLs for this deployment.
    :vartype runtime_uri: list[str]
    """

    _attribute_map = {
        "runtime_uri": {"key": "runtimeUri", "type": "[str]"},
    }

    def __init__(self, *, runtime_uri: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword runtime_uri: Base runtime URLs for this deployment.
        :paramtype runtime_uri: list[str]
        """
        super().__init__(**kwargs)
        self.runtime_uri = runtime_uri


class Environment(ProxyResource):
    """Environment entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.EnvironmentProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "EnvironmentProperties"},
    }

    def __init__(self, *, properties: Optional["_models.EnvironmentProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.EnvironmentProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class EnvironmentListResult(_serialization.Model):
    """The response of a Environment list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Environment items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.Environment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Environment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class EnvironmentProperties(_serialization.Model):
    """Environment properties entity.

    All required parameters must be populated in order to send to Azure.

    :ivar title: Environment title. Required.
    :vartype title: str
    :ivar description: The environment description.
    :vartype description: str
    :ivar kind: Environment kind. Required. Known values are: "development", "testing", "staging",
     and "production".
    :vartype kind: str or ~azure.mgmt.apicenter.models.EnvironmentKind
    :ivar server: Server information of the environment.
    :vartype server: ~azure.mgmt.apicenter.models.EnvironmentServer
    :ivar onboarding: Environment onboarding information.
    :vartype onboarding: ~azure.mgmt.apicenter.models.Onboarding
    :ivar custom_properties: The custom metadata defined for API catalog entities.
    :vartype custom_properties: JSON
    """

    _validation = {
        "title": {"required": True, "max_length": 50, "min_length": 1},
        "kind": {"required": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "server": {"key": "server", "type": "EnvironmentServer"},
        "onboarding": {"key": "onboarding", "type": "Onboarding"},
        "custom_properties": {"key": "customProperties", "type": "object"},
    }

    def __init__(
        self,
        *,
        title: str,
        kind: Union[str, "_models.EnvironmentKind"],
        description: Optional[str] = None,
        server: Optional["_models.EnvironmentServer"] = None,
        onboarding: Optional["_models.Onboarding"] = None,
        custom_properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: Environment title. Required.
        :paramtype title: str
        :keyword description: The environment description.
        :paramtype description: str
        :keyword kind: Environment kind. Required. Known values are: "development", "testing",
         "staging", and "production".
        :paramtype kind: str or ~azure.mgmt.apicenter.models.EnvironmentKind
        :keyword server: Server information of the environment.
        :paramtype server: ~azure.mgmt.apicenter.models.EnvironmentServer
        :keyword onboarding: Environment onboarding information.
        :paramtype onboarding: ~azure.mgmt.apicenter.models.Onboarding
        :keyword custom_properties: The custom metadata defined for API catalog entities.
        :paramtype custom_properties: JSON
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.kind = kind
        self.server = server
        self.onboarding = onboarding
        self.custom_properties = custom_properties


class EnvironmentServer(_serialization.Model):
    """Server information of the environment.

    :ivar type: Type of the server that represents the environment. Known values are: "Azure API
     Management", "Azure compute service", "Apigee API Management", "AWS API Gateway", "Kong API
     Gateway", "Kubernetes", and "MuleSoft API Management".
    :vartype type: str or ~azure.mgmt.apicenter.models.EnvironmentServerType
    :ivar management_portal_uri: The location of the management portal.
    :vartype management_portal_uri: list[str]
    """

    _validation = {
        "management_portal_uri": {"max_items": 1, "min_items": 0},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "management_portal_uri": {"key": "managementPortalUri", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.EnvironmentServerType"]] = None,
        management_portal_uri: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the server that represents the environment. Known values are: "Azure API
         Management", "Azure compute service", "Apigee API Management", "AWS API Gateway", "Kong API
         Gateway", "Kubernetes", and "MuleSoft API Management".
        :paramtype type: str or ~azure.mgmt.apicenter.models.EnvironmentServerType
        :keyword management_portal_uri: The location of the management portal.
        :paramtype management_portal_uri: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.management_portal_uri = management_portal_uri


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.apicenter.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.apicenter.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.apicenter.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.apicenter.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExternalDocumentation(_serialization.Model):
    """Additional, external documentation for the API.

    All required parameters must be populated in order to send to Azure.

    :ivar title: Title of the documentation.
    :vartype title: str
    :ivar description: Description of the documentation.
    :vartype description: str
    :ivar url: URL pointing to the documentation. Required.
    :vartype url: str
    """

    _validation = {
        "title": {"max_length": 50},
        "description": {"max_length": 500},
        "url": {"required": True, "max_length": 200},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "url": {"key": "url", "type": "str"},
    }

    def __init__(
        self, *, url: str, title: Optional[str] = None, description: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword title: Title of the documentation.
        :paramtype title: str
        :keyword description: Description of the documentation.
        :paramtype description: str
        :keyword url: URL pointing to the documentation. Required.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.url = url


class License(_serialization.Model):
    """The license information for the API.

    :ivar name: Name of the license.
    :vartype name: str
    :ivar url: URL pointing to the license details. The URL field is mutually exclusive of the
     identifier field.
    :vartype url: str
    :ivar identifier: SPDX license information for the API. The identifier field is mutually
     exclusive of the URL field.
    :vartype identifier: str
    """

    _validation = {
        "name": {"max_length": 100},
        "url": {"max_length": 200},
        "identifier": {"max_length": 50},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "identifier": {"key": "identifier", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, url: Optional[str] = None, identifier: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the license.
        :paramtype name: str
        :keyword url: URL pointing to the license details. The URL field is mutually exclusive of the
         identifier field.
        :paramtype url: str
        :keyword identifier: SPDX license information for the API. The identifier field is mutually
         exclusive of the URL field.
        :paramtype identifier: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.url = url
        self.identifier = identifier


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.apicenter.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.apicenter.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.apicenter.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.apicenter.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MetadataAssignment(_serialization.Model):
    """Assignment metadata.

    :ivar entity: The entities this metadata schema component gets applied to. Known values are:
     "api", "environment", and "deployment".
    :vartype entity: str or ~azure.mgmt.apicenter.models.MetadataAssignmentEntity
    :ivar required: Required assignment.
    :vartype required: bool
    :ivar deprecated: Deprecated assignment.
    :vartype deprecated: bool
    """

    _attribute_map = {
        "entity": {"key": "entity", "type": "str"},
        "required": {"key": "required", "type": "bool"},
        "deprecated": {"key": "deprecated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        entity: Optional[Union[str, "_models.MetadataAssignmentEntity"]] = None,
        required: Optional[bool] = None,
        deprecated: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity: The entities this metadata schema component gets applied to. Known values are:
         "api", "environment", and "deployment".
        :paramtype entity: str or ~azure.mgmt.apicenter.models.MetadataAssignmentEntity
        :keyword required: Required assignment.
        :paramtype required: bool
        :keyword deprecated: Deprecated assignment.
        :paramtype deprecated: bool
        """
        super().__init__(**kwargs)
        self.entity = entity
        self.required = required
        self.deprecated = deprecated


class MetadataSchema(ProxyResource):
    """Metadata schema entity. Used to define metadata for the entities in API catalog.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.MetadataSchemaProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "MetadataSchemaProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MetadataSchemaProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.MetadataSchemaProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class MetadataSchemaExportRequest(_serialization.Model):
    """The metadata schema export request.

    :ivar assigned_to: An entity the metadata schema is requested for. Known values are: "api",
     "environment", and "deployment".
    :vartype assigned_to: str or ~azure.mgmt.apicenter.models.MetadataAssignmentEntity
    """

    _attribute_map = {
        "assigned_to": {"key": "assignedTo", "type": "str"},
    }

    def __init__(
        self, *, assigned_to: Optional[Union[str, "_models.MetadataAssignmentEntity"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword assigned_to: An entity the metadata schema is requested for. Known values are: "api",
         "environment", and "deployment".
        :paramtype assigned_to: str or ~azure.mgmt.apicenter.models.MetadataAssignmentEntity
        """
        super().__init__(**kwargs)
        self.assigned_to = assigned_to


class MetadataSchemaExportResult(_serialization.Model):
    """The metadata schema export result.

    :ivar format: The export format for the schema. Known values are: "inline" and "link".
    :vartype format: str or ~azure.mgmt.apicenter.models.MetadataSchemaExportFormat
    :ivar value: The result of the export operation.
    :vartype value: str
    """

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "_models.MetadataSchemaExportFormat"]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword format: The export format for the schema. Known values are: "inline" and "link".
        :paramtype format: str or ~azure.mgmt.apicenter.models.MetadataSchemaExportFormat
        :keyword value: The result of the export operation.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.format = format
        self.value = value


class MetadataSchemaListResult(_serialization.Model):
    """The response of a MetadataSchema list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The MetadataSchema items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.MetadataSchema]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetadataSchema]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class MetadataSchemaProperties(_serialization.Model):
    """Metadata schema properties.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: The schema defining the type. Required.
    :vartype schema: str
    :ivar assigned_to: The assignees.
    :vartype assigned_to: list[~azure.mgmt.apicenter.models.MetadataAssignment]
    """

    _validation = {
        "schema": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "schema", "type": "str"},
        "assigned_to": {"key": "assignedTo", "type": "[MetadataAssignment]"},
    }

    def __init__(
        self, *, schema: str, assigned_to: Optional[List["_models.MetadataAssignment"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword schema: The schema defining the type. Required.
        :paramtype schema: str
        :keyword assigned_to: The assignees.
        :paramtype assigned_to: list[~azure.mgmt.apicenter.models.MetadataAssignment]
        """
        super().__init__(**kwargs)
        self.schema = schema
        self.assigned_to = assigned_to


class Onboarding(_serialization.Model):
    """Onboarding information.

    :ivar instructions: Onboarding guide.
    :vartype instructions: str
    :ivar developer_portal_uri: The location of the development portal.
    :vartype developer_portal_uri: list[str]
    """

    _validation = {
        "developer_portal_uri": {"max_items": 1, "min_items": 0},
    }

    _attribute_map = {
        "instructions": {"key": "instructions", "type": "str"},
        "developer_portal_uri": {"key": "developerPortalUri", "type": "[str]"},
    }

    def __init__(
        self, *, instructions: Optional[str] = None, developer_portal_uri: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword instructions: Onboarding guide.
        :paramtype instructions: str
        :keyword developer_portal_uri: The location of the development portal.
        :paramtype developer_portal_uri: list[str]
        """
        super().__init__(**kwargs)
        self.instructions = instructions
        self.developer_portal_uri = developer_portal_uri


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.apicenter.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.apicenter.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.apicenter.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.apicenter.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.apicenter.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Service(TrackedResource):
    """The service entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.ServiceProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.apicenter.models.ManagedServiceIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ServiceProperties"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ServiceProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.ServiceProperties
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.apicenter.models.ManagedServiceIdentity
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.identity = identity


class ServiceListResult(_serialization.Model):
    """The response of a Service list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Service items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.Service]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Service]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServiceProperties(_serialization.Model):
    """The properties of the service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the service. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.apicenter.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None


class ServiceUpdate(_serialization.Model):
    """The type used for update operations of the Service.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.apicenter.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.apicenter.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.apicenter.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.apicenter.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.apicenter.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.apicenter.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TermsOfService(_serialization.Model):
    """Terms of service for the API.

    All required parameters must be populated in order to send to Azure.

    :ivar url: URL pointing to the terms of service. Required.
    :vartype url: str
    """

    _validation = {
        "url": {"required": True, "max_length": 200},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: str, **kwargs: Any) -> None:
        """
        :keyword url: URL pointing to the terms of service. Required.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Workspace(ProxyResource):
    """Workspace entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.apicenter.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.apicenter.models.WorkspaceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "WorkspaceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.WorkspaceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.apicenter.models.WorkspaceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class WorkspaceListResult(_serialization.Model):
    """The response of a Workspace list operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The Workspace items on this page. Required.
    :vartype value: list[~azure.mgmt.apicenter.models.Workspace]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Workspace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkspaceProperties(_serialization.Model):
    """Workspace properties.

    All required parameters must be populated in order to send to Azure.

    :ivar title: Workspace title. Required.
    :vartype title: str
    :ivar description: Workspace description.
    :vartype description: str
    """

    _validation = {
        "title": {"required": True, "max_length": 50, "min_length": 1},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, title: str, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword title: Workspace title. Required.
        :paramtype title: str
        :keyword description: Workspace description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
