## Tests to make sure that the deparse(as.vector(x)) construction is not
## tripping us up again.
library(nlme)
options(digits = 7)
data(Loblolly)
fm1 <- nlme(height ~ SSasymp(age, Asym, R0, lrc),
            data = Loblolly,
            fixed = Asym + R0 + lrc ~ 1,
            random = Asym ~ 1,
            start = c(Asym = 103, R0 = -8.5, lrc = -3.3))
fm1
vcV <- VarCorr(fm1)[,"Variance"]
stopifnot(
    all.equal(fixef(fm1),
	      c(Asym = 101.4496, R0 = -8.6273307, lrc = -3.2337507))
   ,
    all.equal(as.numeric(vcV),
              c(13.3271856, 0.5167634), tol = 1e-6)
)


model <- height ~ SSasymp(age, Asym, R0, lrc)
fixed <- Asym + R0 + lrc ~ 1
random <- Asym ~ 1
start <- c(Asym = 103, R0 = -8.5, lrc = -3.3)
fm2 <- nlme(model,
            data = Loblolly,
            fixed = fixed,
            random = random,
            start = start)
fm2
## equal apart from 'call' :
fm2$call <- fm1$call
## BUT with macOS's Accelerate:
##   Component "apVar": Mean relative difference: 7.07812e-05
stopifnot(all.equal(fm1, fm2, tolerance = 1e-15))

## deparse can give multiple lines
## example from https://stat.ethz.ch/pipermail/r-help/2006-February/086648.html
"mydata2" <-
structure(list(Tps = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3,
3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6,
6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9,
9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 14,
14, 14, 14, 14, 17, 17, 17, 17, 17, 20, 20, 20, 20, 25, 28, 29,
50, 50, 50, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136,
1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4,
4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10,
10, 10, 11, 11, 11, 11, 11, 11, 14, 14, 14, 14, 14, 17, 17, 17,
17, 17, 20, 20, 20, 20, 25, 28, 29, 50, 50, 50, 136, 136, 136,
136, 136, 136, 136, 136, 136, 136, 1, 1, 1, 1, 1, 1, 2, 2, 2,
2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5,
6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8,
8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11,
11, 11, 14, 14, 14, 14, 14, 17, 17, 17, 17, 17, 20, 20, 20, 20,
25, 28, 29, 50, 50, 50, 136, 136, 136, 136, 136, 136, 136, 136,
136, 136), Conc = c(0, 0, 0, 0, 0, 0, 0, 0.807852503274902,
0.204371494701886,
0.579222129993907, 0.989062273721619, 0, 1.11728297897571,
1.41057428121324,
0.888883702851307, 1.259907624008, 1.45753269675829, 1.07077516747401,
0.843279379, 0, 0.763110069196737, 1.11297791434297, 1.10087763997637,
0.946929594501016, 1.33112168, 0.654041755, 0.694167499, 1.289548703,
1.117139864, 0.807196192, 0.720221376552025, 0.560082823, 0.476583438,
2.590855204, 0.51510972, 1.072946887, 0.537999938614396, 0.886684225905255,
0.630178116793598, 1.31534758842196, 1.33333958571746, 0.922032210748255,
0.429930193046174, 1.35881467717335, 0.790045927902363, 1.22484702570724,
0.808104508207897, 1.31185966817903, 1.51837686425553, 1.74105163638734,
1.80365598487402, 1.13240352674377, 1.50086243061644, 2.06355364280445,
0.439350890906039, 1.54692793444949, 1.78758216051046, 1.09043400023239,
0.811328376840514, 0.459192443530981, 0.695333473157298, 0.387995007681174,
0.784627063444921, 1.02282256375842, 0.382687104107726, 0.554290634950242,
0.130420456296453, 0.324194753224919, 0.31106140274139, 0.513473505828888,
0.878620320248701, 1.18404358659996, 0.136926837896477, 0, 0,
0.835588760032974, 0.558617235576616, 1.21002805866839, 0.769381068031404,
1.04514254228094, 0.373251847173678, 0.389005898972802, 0.183141006154896,
0.223596336820146, 0.315526423315647, 0.0930349732768131,
0.169959185212759,
0.161878841748425, 0, 0.0483041009105874, 0, 0, 0, 0.0777005553478052,
0, 0.153175826795441, 0.0428171049833677, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 26.564295705327, 5.5893744508169, 7.22612934071834,
36.6563989567777, 0, 28.8967184437329, 28.4030370337251, 28.0886043901352,
26.1230935842208, 28.8895673910072, 42.6814210131968, 32.3555695551062,
0.76883326657205, 34.6159136622156, 38.329242204291, 56.4476583636484,
26.6249506083603, 31.3001451026823, 23.7339071829084, 23.3702284599355,
36.669903715038, 44.7377244306005, 31.2079335923023, 32.8613384312272,
29.4259634309146, 45.6112405959009, 48.1231689836687, 55.0037961570027,
32.9822316456421, 20.0382768189682, 26.0986380308655, 28.8915584506145,
28.7949023823068, 30.0278417498425, 58.8089779973569, 20.3602570111197,
29.6269605259023, 28.4404986724604, 30.2165182590977, 19.9204461889074,
31.1019196559556, 30.3847467747055, 36.8726911479995, 51.0618036275519,
23.5408013442579, 36.6948355347593, 27.4753860809429, 24.1341667099646,
27.5411488989643, 35.9021799354022, 19.7417897046158, 31.1403887303244,
46.1743622734049, 34.8235854891765, 22.1714704189293, 33.6805966894274,
35.2814908686112, 42.9767437212852, 38.1264997164547, 5.3651357974451,
42.8990434918385, 25.4908883698364, 25.99649502, 36.4958105490917,
40.8004126550705, 5.36867162116895, 0.00898476265269363, 0,
27.6810997945798,
28.7918300045713, 45.7577183830352, 35.9276318604787, 34.9717618087238,
29.620354272564, 24.6537513599869, 13.5363982464958, 25.8289073574818,
12.0090406245759, 4.753436805, 11.849214652228, 8.41410147611612,
0, 1.80855352862552, 1.1987530031681, 1.01148025243171, 0.495675369574172,
1.62701127228732, 0, 16.6288242287241, 1.23656061354912, 0.323708776035328,
0, 0.566916625204436, 0, 0, 0, 0, 0, 0, 0, 2.53578781871283,
3.50083667130797, 0, 0.98049572179098, 0, 3.57129673217304,
2.77298867949388,
2.12302645642669, 4.11923869203499, 4.69069462193674, 2.8698666062651,
2.05079837323067, 0.0602771574448942, 5.96454350250626, 2.26267114439802,
3.06911285674854, 2.04233129537404, 2.62181873844029, 1.51813653072598,
1.46193772981073, 2.69864635755833, 3.44016493913122, 2.50834832469627,
3.48170744166168, 1.00637581555435, 1.67065398473081, 4.18855363095027,
3.39649762611015, 1.72804613460423, 1.40053679329531, 2.37032387724109,
3.19332545080983, 2.49474373894248, 2.17800931288708, 2.7601484443213,
0.91266104095844, 1.93485048639199, 1.19692593420788, 1.79537330666258,
2.14020930767983, 3.0122526724942, 2.81112226980754, 3.54890724398174,
3.01022926452999, 2.38263226710738, 3.53569238341869, 3.47869329713911,
0.679333339820719, 2.4764260756438, 3.82615100065366, 2.20449890383871,
1.371303113329, 1.2427787019995, 1.73319133880954, 0.391268883238408,
1.73610193837913, 2.68494324646718, 1.77065393606844, 1.45079980147062,
0.763775702906329, 0.98566725668627, 0.37838763208699, 0.841811919286804,
1.46436462204795, 1.98409602726, 0.507005887891038, 0.465515668274195,
0, 1.873365675227, 1.69023864630648, 2.65530855919137, 2.34392199908302,
1.61917643594837, 1.05165934333345, 0.564642823436471, 0.121621029620328,
0.515007625737071, 0.524345809084086, 0.130898614090571, 0.332427740242623,
0.110214989555118, 0, 0.128642193589, 0.119407067173878, 0.128926224027295,
0.0622331866694357, 0.215645168287442, 0, 0.859343941945178,
0.0500810300696456, 0, 0, 0.0628746592609754), Organ =
structure(rep(c(1L,3L,2L), each=100),
          .Label = c("Carc", "TD", "Foie"), class = c("ordered", "factor"))),
row.names = as.character(1:300),
class = c("nfnGroupedData", "nfGroupedData", "groupedData",
"data.frame"), formula = quote(Conc ~ Tps | Organ), FUN = function (x)
max(x, na.rm = TRUE), order.groups = TRUE)

mydata2$Dose <- 100
mymod3 <- nlsList(Conc+1 ~ Dose * exp(lKe+lKa-lCl) *
   (exp(-exp(lKe)*Tps)-exp(-exp(lKa)*Tps)) /(exp(lKa)-exp(lKe)) | Organ,
   data=mydata2, start= c(lKe=-2.77, lKa=-1.41, lCl=-1.13))
mymod3
(sm3 <- summary(mymod3))

stopifnot(
    all.equal(coef(sm3),
              array(c(-5.0742843, -3.0284227, -2.9006161, 2.9998357, 1.7851301,
                      0.26206915, -1.6915208, -1.6964717, -11.068132, 4.263934e-43,
                      1.4546246e-17, 4.9468128e-09, -0.18001926, -0.67150218, -1.3685062,
                      2.9213761, 1.6846644, 0.22295774, -0.061621391, -0.39859699,
                      -6.1379624, 0.37741845, 0.015884023, 0.0005718832, -1.1485352,
                      0.086542979, -2.2452234, 2.769282, 1.177223, 0.13378181, -0.41474113,
                      0.073514514, -16.782726, 3.9250025e-08, 0.65176229, 4.8777767e-16),
                    dim = c(3L, 4L, 3L),
                    dimnames =
                        list(c("Carc", "TD", "Foie"),
                             c("Estimate", "Std. Error", "t value", "Pr(>|t|)"),
                             c("lKe", "lKa", "lCl"))),
              tolerance = 1e-7)
)

