% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDataFrameFactor.R
\name{saveObject,DataFrameFactor-method}
\alias{saveObject,DataFrameFactor-method}
\alias{stageObject,DataFrameFactor-method}
\title{Stage a DataFrameFactor object}
\usage{
\S4method{saveObject}{DataFrameFactor}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{DataFrameFactor} object.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments, to pass to internal \code{\link{altSaveObject}} calls.}
}
\value{
\code{x} is saved to an on-disk representation inside \code{path}.
}
\description{
Stage a \linkS4class{DataFrameFactor} object, a generalization of the base factor for \linkS4class{DataFrame} levels.
}
\examples{
library(S4Vectors)
df <- DataFrame(X=LETTERS[1:5], Y=1:5)
out <- DataFrameFactor(df[sample(5, 100, replace=TRUE),,drop=FALSE])

tmp <- tempfile()
saveObject(out, tmp)
list.files(tmp, recursive=TRUE)

}
\author{
Aaron Lun
}
