% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ca.R
\name{get_ca}
\alias{get_ca}
\alias{get_ca_col}
\alias{get_ca_row}
\title{Extract the results for rows/columns - CA}
\usage{
get_ca(res.ca, element = c("row", "col"))

get_ca_col(res.ca)

get_ca_row(res.ca)
}
\arguments{
\item{res.ca}{an object of class CA [FactoMineR], ca [ca], coa [ade4];
correspondence [MASS].}

\item{element}{the element to subset from the output. Possible values are "row" or "col".}
}
\value{
a list of matrices containing the results for the active rows/columns including : 
\item{coord}{coordinates for the rows/columns}
\item{cos2}{cos2 for the rows/columns}
\item{contrib}{contributions of the rows/columns}
\item{inertia}{inertia of the rows/columns}
}
\description{
Extract all the results (coordinates, squared cosine, contributions and inertia) 
for the active row/column variables from Correspondence Analysis (CA) outputs.\cr\cr
\itemize{
\item get_ca(): Extract the results for rows and columns
\item get_ca_row(): Extract the results for rows only
\item get_ca_col(): Extract the results for columns only
}
}
\examples{
\donttest{
# Install and load FactoMineR to compute CA
# install.packages("FactoMineR")
 library("FactoMineR")
 data("housetasks")
 res.ca <- CA(housetasks, graph = FALSE)
 
# Result for column variables
 col <- get_ca_col(res.ca)
 col # print
 head(col$coord) # column coordinates
 head(col$cos2) # column cos2
 head(col$contrib) # column contributions
 
# Result for row variables
 row <- get_ca_row(res.ca)
 row # print
 head(row$coord) # row coordinates
 head(row$cos2) # row cos2
 head(row$contrib) # row contributions
 
 # You can also use the function get_ca()
 get_ca(res.ca, "row") # Results for rows
 get_ca(res.ca, "col") # Results for columns
 }
}
\references{
http://www.sthda.com
}
\author{
Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}
