% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmatrix_progress.R
\name{ggmatrix_progress}
\alias{ggmatrix_progress}
\title{\code{\link{ggmatrix}} default progress bar}
\usage{
ggmatrix_progress(
  format = " plot: [:plot_i,:plot_j] [:bar]:percent est::eta ",
  clear = TRUE,
  show_after = 0,
  ...
)
}
\arguments{
\item{format, clear, show_after, ...}{parameters supplied directly to \code{progress::\link[progress]{progress_bar}$new()}}
}
\value{
function that accepts a plot matrix as the first argument and \code{...} for future expansion. Internally, the plot matrix is used to determine the total number of plots for the progress bar.
}
\description{
\code{\link{ggmatrix}} default progress bar
}
\examples{
p_ <- GGally::print_if_interactive

pm <- ggpairs(iris, 1:2, progress = ggmatrix_progress())
p_(pm)

# does not clear after finishing
pm <- ggpairs(iris, 1:2, progress = ggmatrix_progress(clear = FALSE))
p_(pm)
}
