% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterise.R
\name{rasterise}
\alias{rasterise}
\alias{rasterise.Layer}
\alias{rasterise.list}
\alias{rasterise.ggplot}
\alias{rasterize}
\title{Rasterise ggplot layers
Takes a ggplot object or a layer as input and renders their graphical output as a raster.}
\usage{
rasterise(input, ...)

\method{rasterise}{Layer}(input, dpi = NULL, dev = "cairo", scale = 1, ...)

\method{rasterise}{list}(input, dpi = NULL, dev = "cairo", scale = 1, ...)

\method{rasterise}{ggplot}(
  input,
  layers = c("Point", "Tile"),
  dpi = NULL,
  dev = "cairo",
  scale = 1,
  ...
)

rasterize(input, ...)
}
\arguments{
\item{input}{ggplot plot object to rasterize}

\item{...}{other arguments}

\item{dpi}{integer Sets the desired resolution in dots per inch (default=NULL).}

\item{dev}{string Specifies the device used, which can be one of: \code{"cairo"}, \code{"ragg"} or \code{"ragg_png"} (default="cairo").}

\item{scale}{numeric Scaling factor to modify the raster object size (default=1). The parameter 'scale=1' results in an object size that is unchanged, 'scale'>1 increase the size, and 'scale'<1 decreases the size. These parameters are passed to 'height' and 'width' of grid::grid.raster(). Please refer to 'rasterise()' and 'grid::grid.raster()' for more details.}

\item{layers}{list of layer types that should be rasterized}
}
\value{
A modified \code{Layer} object.
}
\description{
Rasterise ggplot layers
Takes a ggplot object or a layer as input and renders their graphical output as a raster.
}
\details{
The default \code{dpi} (\code{NULL} (i.e. let the device decide)) can conveniently be controlled by setting the option \code{"ggrastr.default.dpi"} (e.g. \code{options("ggrastr.default.dpi" = 30)} for drafting).
}
\examples{
require(ggplot2)
# `rasterise()` is used to wrap layers
ggplot(pressure, aes(temperature, pressure)) +
  rasterise(geom_line())

# The `dpi` argument controls resolution
ggplot(faithful, aes(eruptions, waiting)) +
  rasterise(geom_point(), dpi = 5)

# The `dev` argument offers a few options for devices
require(ragg)
ggplot(diamonds, aes(carat, depth, z = price)) +
  rasterise(stat_summary_hex(), dev = "ragg")

# The `scale` argument allows you to render a 'big' plot in small window, or vice versa.
ggplot(faithful, aes(eruptions, waiting)) +
  rasterise(geom_point(), scale = 4)
}
\author{
Teun van den Brand <t.vd.brand@nki.nl>
}
