% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\alias{render.character}
\alias{render.fs_path}
\alias{render.jinjar_template}
\title{Render a template}
\usage{
render(.x, ...)

\method{render}{character}(.x, ..., .config = default_config())

\method{render}{fs_path}(.x, ..., .config = default_config())

\method{render}{jinjar_template}(.x, ...)
}
\arguments{
\item{.x}{The template. Choices:
\itemize{
\item A template string.
\item A path to a template file (use \code{\link[fs:path]{fs::path()}}).
\item A parsed template (use \code{\link[=parse_template]{parse_template()}}).
}}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Data passed to the template.}

\item{.config}{The engine configuration. The default matches Jinja defaults,
but you can use \code{\link[=jinjar_config]{jinjar_config()}} to customize things like syntax delimiters,
whitespace control, and loading auxiliary templates.}
}
\value{
String containing rendered template.
}
\description{
Data is passed to a template to render the final document.
}
\examples{
# pass data as arguments
render("Hello {{ name }}!", name = "world")

# pass data as list
params <- list(name = "world")
render("Hello {{ name }}!", !!!params)

# render template file
\dontrun{
render(fs::path("template.txt"), name = "world")
}
}
\seealso{
\itemize{
\item \code{\link[=parse_template]{parse_template()}} supports parsing a template once and rendering multiple
times with different data variables.
\item \code{vignette("template-syntax")} describes how to write templates.
}
}
