% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOA.R
\name{createBusht}
\alias{createBusht}
\title{Create an orthogonal array using the Bush algorithm with alternate strength.}
\usage{
createBusht(q, ncol, strength, bRandom = TRUE)
}
\arguments{
\item{q}{the number of symbols in the array}

\item{ncol}{number of parameters or columns}

\item{strength}{the strength of the array to be created}

\item{bRandom}{should the array be randomized}
}
\value{
an orthogonal array
}
\description{
The \code{busht} program produces \code{OA( q^t, k, q, t )},  \code{k <= q+1}, \code{t>=3},
for prime powers \code{q}.
}
\details{
From Owen: An orthogonal array \code{A} is a matrix of \code{n} rows, \code{k}
columns with every element being one of \code{q} symbols
\code{0,...,q-1}.  The array has strength \code{t} if, in every \code{n} by \code{t}
submatrix, the \code{q^t} possible distinct rows, all appear
the same number of times.  This number is the index
of the array, commonly denoted \code{lambda}.  Clearly,
\code{lambda*q^t=n}. The notation for such an array is \code{OA( n, k, q, t )}.
}
\examples{
set.seed(1234)
A <- createBusht(3, 4, 2, TRUE)
B <- createBusht(3, 4, 3, FALSE)
G <- createBusht(3, 4, 3, TRUE)
}
\references{
Owen, Art.  Orthogonal Arrays for: Computer Experiments, Visualizations, and Integration in high dimenstions. \url{http://lib.stat.cmu.edu/designs/oa.c}. 1994
K.A. Bush (1952) Annals of Mathematical Statistics, Vol 23 pp 426-434
}
\seealso{
Other methods to create orthogonal arrays [createBoseBush()],
[createBose()], [createAddelKemp()], [createAddelKemp3()],
[createAddelKempN()], [createBoseBushl()]
}
