% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{RMSPE}
\alias{RMSPE}
\title{Root Mean Square Percentage Error Loss}
\usage{
RMSPE(y_pred, y_true)
}
\arguments{
\item{y_pred}{Estimated target values vector}

\item{y_true}{Ground truth (correct) target values vector}
}
\value{
Root Mean Squared Percentage Error Loss
}
\description{
Compute the root mean squared percentage error regression loss.
}
\examples{
data(cars)
reg <- lm(log(dist) ~ log(speed), data = cars)
RMSPE(y_pred = exp(reg$fitted.values), y_true = cars$dist)
}

