% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.join.R
\name{list.join}
\alias{list.join}
\title{Join two lists by single or multiple keys}
\usage{
list.join(x, y, xkey, ykey, ..., keep.order = TRUE)
}
\arguments{
\item{x}{The first list}

\item{y}{The second list}

\item{xkey}{A lambda expression that determines the key for list \code{x}}

\item{ykey}{A lambda expression that determines the key for list \code{y},
same to \code{xkey} if missing}

\item{...}{The additional parameters passed to \code{merge.data.frame}}

\item{keep.order}{Should the order of \code{x} be kept?}
}
\description{
Join two lists by single or multiple keys
}
\examples{
l1 <- list(p1=list(name='Ken',age=20),
       p2=list(name='James',age=21),
       p3=list(name='Jenny',age=20))
l2 <- list(p1=list(name='Jenny',age=20,type='A'),
       p2=list(name='Ken',age=20,type='B'),
       p3=list(name='James',age=22,type='A'))
list.join(l1, l2, name)
list.join(l1, l2, .[c('name','age')])
}
