% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNG.R
\docType{methods}
\name{.getRNG}
\alias{.getRNG}
\alias{.getRNG,ANY-method}
\alias{.getRNG,missing-method}
\alias{.getRNG,list-method}
\alias{.getRNG,numeric-method}
\title{Getting RNG Seeds}
\usage{
.getRNG(object, ...)

\S4method{.getRNG}{ANY}(object, ...)

\S4method{.getRNG}{missing}(object)

\S4method{.getRNG}{list}(object)

\S4method{.getRNG}{numeric}(object, ...)
}
\arguments{
\item{object}{an R object from which RNG settings can be extracted, e.g. an
integer vector containing a suitable value for \code{.Random.seed} or embedded
RNG data, e.g., in S3/S4 slot \code{rng} or \code{rng$noise}.}

\item{...}{extra arguments to allow extension and passed to a suitable S4 method
\code{.getRNG} or \code{.setRNG}.}
}
\description{
\code{.getRNG} is an S4 generic that extract RNG settings from a variety of
object types.
Its methods define the workhorse functions that are called by \code{getRNG}.
}
\section{Methods (by class)}{

"ANY": Default method that tries to extract RNG information from \code{object}, by
looking sequentially to a slot named \code{'rng'}, a slot named \code{'rng.seed'}
or an attribute names \code{'rng'}.

It returns \code{NULL} if no RNG data was found.


"missing": Returns the current RNG settings.


"list": Method for S3 objects, that aims at reproducing the behaviour of the function
\code{getRNG} of the package \code{getRNG}.

It sequentially looks for RNG data in elements \code{'rng'}, \code{noise$rng}
if element \code{'noise'} exists and is a \code{list}, or in attribute \code{'rng'}.


"numeric": Method for numeric vectors, which returns the object itself, coerced into an integer
vector if necessary, as it is assumed to already represent a value for
\code{\link{.Random.seed}}.
}

