# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Role.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.usermgmt


# interface
class Role(Interface):
    idlType = "usermgmt.Role:1.0.0"

    ERR_INVALID_VALUE = 1

    # structure
    class Privilege(Structure):
        idlType = "usermgmt.Role.Privilege:1.0.0"
        elements = ["name", "args"]

        def __init__(self, name, args):
            typecheck.is_string(name, AssertionError)
            for x0 in args:
                typecheck.is_string(x0, AssertionError)

            self.name = name
            self.args = args

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                args = [x0 for x0 in json['args']],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['args'] = [x0 for x0 in self.args]
            return json

    # structure
    class Info(Structure):
        idlType = "usermgmt.Role.Info:1.0.0"
        elements = ["description", "locked", "privileges"]

        def __init__(self, description, locked, privileges):
            typecheck.is_string(description, AssertionError)
            typecheck.is_bool(locked, AssertionError)
            for x0 in privileges:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.Role.Privilege, AssertionError)

            self.description = description
            self.locked = locked
            self.privileges = privileges

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                description = json['description'],
                locked = json['locked'],
                privileges = [raritan.rpc.usermgmt.Role.Privilege.decode(x0, agent) for x0 in json['privileges']],
            )
            return obj

        def encode(self):
            json = {}
            json['description'] = self.description
            json['locked'] = self.locked
            json['privileges'] = [raritan.rpc.usermgmt.Role.Privilege.encode(x0) for x0 in self.privileges]
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.usermgmt.Role.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.usermgmt.Role.Info, DecodeException)
            return _ret_

    class _updateFull(Interface.Method):
        name = 'updateFull'

        @staticmethod
        def encode(info):
            typecheck.is_struct(info, raritan.rpc.usermgmt.Role.Info, AssertionError)
            args = {}
            args['info'] = raritan.rpc.usermgmt.Role.Info.encode(info)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Role, self).__init__(target, agent)
        self.getInfo = Role._getInfo(self)
        self.updateFull = Role._updateFull(self)

#
# Section generated by IdlC from "RoleManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.usermgmt


# value object
class RoleEvent(raritan.rpc.event.UserEvent):
    idlType = "usermgmt.RoleEvent:1.0.0"

    def __init__(self, rolename, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.RoleEvent, self).__init__(actUserName, actIpAddr, source)
        typecheck.is_string(rolename, AssertionError)

        self.rolename = rolename

    def encode(self):
        json = super(raritan.rpc.usermgmt.RoleEvent, self).encode()
        json['rolename'] = self.rolename
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            rolename = json['rolename'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["rolename"]
        elements = elements + super(raritan.rpc.usermgmt.RoleEvent, self).listElements()
        return elements

# value object
class RoleAdded(RoleEvent):
    idlType = "usermgmt.RoleAdded:1.0.0"

    def __init__(self, rolename, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.RoleAdded, self).__init__(rolename, actUserName, actIpAddr, source)

    def encode(self):
        json = super(raritan.rpc.usermgmt.RoleAdded, self).encode()
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            # for usermgmt.RoleEvent
            rolename = json['rolename'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = []
        elements = elements + super(raritan.rpc.usermgmt.RoleAdded, self).listElements()
        return elements

# value object
class RoleRemoved(RoleEvent):
    idlType = "usermgmt.RoleRemoved:1.0.0"

    def __init__(self, rolename, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.RoleRemoved, self).__init__(rolename, actUserName, actIpAddr, source)

    def encode(self):
        json = super(raritan.rpc.usermgmt.RoleRemoved, self).encode()
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            # for usermgmt.RoleEvent
            rolename = json['rolename'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = []
        elements = elements + super(raritan.rpc.usermgmt.RoleRemoved, self).listElements()
        return elements

# value object
class RoleChanged(RoleEvent):
    idlType = "usermgmt.RoleChanged:1.0.0"

    def __init__(self, oldSettings, newSettings, rolename, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.RoleChanged, self).__init__(rolename, actUserName, actIpAddr, source)
        typecheck.is_struct(oldSettings, raritan.rpc.usermgmt.Role.Info, AssertionError)
        typecheck.is_struct(newSettings, raritan.rpc.usermgmt.Role.Info, AssertionError)

        self.oldSettings = oldSettings
        self.newSettings = newSettings

    def encode(self):
        json = super(raritan.rpc.usermgmt.RoleChanged, self).encode()
        json['oldSettings'] = raritan.rpc.usermgmt.Role.Info.encode(self.oldSettings)
        json['newSettings'] = raritan.rpc.usermgmt.Role.Info.encode(self.newSettings)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            oldSettings = raritan.rpc.usermgmt.Role.Info.decode(json['oldSettings'], agent),
            newSettings = raritan.rpc.usermgmt.Role.Info.decode(json['newSettings'], agent),
            # for usermgmt.RoleEvent
            rolename = json['rolename'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["oldSettings", "newSettings"]
        elements = elements + super(raritan.rpc.usermgmt.RoleChanged, self).listElements()
        return elements

# interface
class RoleManager(Interface):
    idlType = "usermgmt.RoleManager:1.0.0"

    ERR_ROLE_ALREADY_EXISTS = 1

    ERR_MAX_ROLES_REACHED = 2

    ERR_INVALID_VALUE = 3

    ERR_ROLE_DOESNT_EXIST = 1

    ERR_ROLE_NOT_DELETABLE = 2

    # structure
    class ArgumentDesc(Structure):
        idlType = "usermgmt.RoleManager.ArgumentDesc:1.0.0"
        elements = ["name", "desc"]

        def __init__(self, name, desc):
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(desc, AssertionError)

            self.name = name
            self.desc = desc

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                desc = json['desc'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['desc'] = self.desc
            return json

    # structure
    class PrivilegeDesc(Structure):
        idlType = "usermgmt.RoleManager.PrivilegeDesc:1.0.0"
        elements = ["name", "desc", "args"]

        def __init__(self, name, desc, args):
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(desc, AssertionError)
            for x0 in args:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.RoleManager.ArgumentDesc, AssertionError)

            self.name = name
            self.desc = desc
            self.args = args

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                desc = json['desc'],
                args = [raritan.rpc.usermgmt.RoleManager.ArgumentDesc.decode(x0, agent) for x0 in json['args']],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['desc'] = self.desc
            json['args'] = [raritan.rpc.usermgmt.RoleManager.ArgumentDesc.encode(x0) for x0 in self.args]
            return json

    # structure
    class RoleAccount(Structure):
        idlType = "usermgmt.RoleManager.RoleAccount:1.0.0"
        elements = ["id", "name", "info"]

        def __init__(self, id, name, info):
            typecheck.is_int(id, AssertionError)
            typecheck.is_string(name, AssertionError)
            typecheck.is_struct(info, raritan.rpc.usermgmt.Role.Info, AssertionError)

            self.id = id
            self.name = name
            self.info = info

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                name = json['name'],
                info = raritan.rpc.usermgmt.Role.Info.decode(json['info'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['name'] = self.name
            json['info'] = raritan.rpc.usermgmt.Role.Info.encode(self.info)
            return json

    # structure
    class Info(Structure):
        idlType = "usermgmt.RoleManager.Info:1.0.0"
        elements = ["privileges", "roles"]

        def __init__(self, privileges, roles):
            for x0 in privileges:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.RoleManager.PrivilegeDesc, AssertionError)
            for x0 in roles:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.RoleManager.RoleAccount, AssertionError)

            self.privileges = privileges
            self.roles = roles

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                privileges = [raritan.rpc.usermgmt.RoleManager.PrivilegeDesc.decode(x0, agent) for x0 in json['privileges']],
                roles = [raritan.rpc.usermgmt.RoleManager.RoleAccount.decode(x0, agent) for x0 in json['roles']],
            )
            return obj

        def encode(self):
            json = {}
            json['privileges'] = [raritan.rpc.usermgmt.RoleManager.PrivilegeDesc.encode(x0) for x0 in self.privileges]
            json['roles'] = [raritan.rpc.usermgmt.RoleManager.RoleAccount.encode(x0) for x0 in self.roles]
            return json

    class _createRoleFull(Interface.Method):
        name = 'createRoleFull'

        @staticmethod
        def encode(name, info):
            typecheck.is_string(name, AssertionError)
            typecheck.is_struct(info, raritan.rpc.usermgmt.Role.Info, AssertionError)
            args = {}
            args['name'] = name
            args['info'] = raritan.rpc.usermgmt.Role.Info.encode(info)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _deleteRole(Interface.Method):
        name = 'deleteRole'

        @staticmethod
        def encode(name):
            typecheck.is_string(name, AssertionError)
            args = {}
            args['name'] = name
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getAllRoleNames(Interface.Method):
        name = 'getAllRoleNames'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getAllRoles(Interface.Method):
        name = 'getAllRoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.usermgmt.RoleManager.RoleAccount.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.RoleManager.RoleAccount, DecodeException)
            return _ret_

    class _getAllPrivileges(Interface.Method):
        name = 'getAllPrivileges'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.usermgmt.RoleManager.PrivilegeDesc.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.RoleManager.PrivilegeDesc, DecodeException)
            return _ret_

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.usermgmt.RoleManager.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.usermgmt.RoleManager.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(RoleManager, self).__init__(target, agent)
        self.createRoleFull = RoleManager._createRoleFull(self)
        self.deleteRole = RoleManager._deleteRole(self)
        self.getAllRoleNames = RoleManager._getAllRoleNames(self)
        self.getAllRoles = RoleManager._getAllRoles(self)
        self.getAllPrivileges = RoleManager._getAllPrivileges(self)
        self.getInfo = RoleManager._getInfo(self)

#
# Section generated by IdlC from "User.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.usermgmt


# enumeration
class SnmpV3SecLevel(Enumeration):
    idlType = "usermgmt.SnmpV3SecLevel:1.0.0"
    values = ["NO_AUTH_NO_PRIV", "AUTH_NO_PRIV", "AUTH_PRIV"]

SnmpV3SecLevel.NO_AUTH_NO_PRIV = SnmpV3SecLevel(0)
SnmpV3SecLevel.AUTH_NO_PRIV = SnmpV3SecLevel(1)
SnmpV3SecLevel.AUTH_PRIV = SnmpV3SecLevel(2)

# enumeration
class SnmpV3AuthProto(Enumeration):
    idlType = "usermgmt.SnmpV3AuthProto:1.0.0"
    values = ["MD5", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"]

SnmpV3AuthProto.MD5 = SnmpV3AuthProto(0)
SnmpV3AuthProto.SHA1 = SnmpV3AuthProto(1)
SnmpV3AuthProto.SHA224 = SnmpV3AuthProto(2)
SnmpV3AuthProto.SHA256 = SnmpV3AuthProto(3)
SnmpV3AuthProto.SHA384 = SnmpV3AuthProto(4)
SnmpV3AuthProto.SHA512 = SnmpV3AuthProto(5)

# enumeration
class SnmpV3PrivProto(Enumeration):
    idlType = "usermgmt.SnmpV3PrivProto:1.0.0"
    values = ["DES", "AES128", "AES192", "AES256", "AES192_3DES", "AES256_3DES"]

SnmpV3PrivProto.DES = SnmpV3PrivProto(0)
SnmpV3PrivProto.AES128 = SnmpV3PrivProto(1)
SnmpV3PrivProto.AES192 = SnmpV3PrivProto(2)
SnmpV3PrivProto.AES256 = SnmpV3PrivProto(3)
SnmpV3PrivProto.AES192_3DES = SnmpV3PrivProto(4)
SnmpV3PrivProto.AES256_3DES = SnmpV3PrivProto(5)

# structure
class SnmpV3Settings(Structure):
    idlType = "usermgmt.SnmpV3Settings:2.0.0"
    elements = ["enabled", "secLevel", "authProtocol", "usePasswordAsAuthPassphrase", "haveAuthPassphrase", "authPassphrase", "privProtocol", "useAuthPassphraseAsPrivPassphrase", "havePrivPassphrase", "privPassphrase"]

    def __init__(self, enabled, secLevel, authProtocol, usePasswordAsAuthPassphrase, haveAuthPassphrase, authPassphrase, privProtocol, useAuthPassphraseAsPrivPassphrase, havePrivPassphrase, privPassphrase):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(secLevel, raritan.rpc.usermgmt.SnmpV3SecLevel, AssertionError)
        typecheck.is_enum(authProtocol, raritan.rpc.usermgmt.SnmpV3AuthProto, AssertionError)
        typecheck.is_bool(usePasswordAsAuthPassphrase, AssertionError)
        typecheck.is_bool(haveAuthPassphrase, AssertionError)
        typecheck.is_string(authPassphrase, AssertionError)
        typecheck.is_enum(privProtocol, raritan.rpc.usermgmt.SnmpV3PrivProto, AssertionError)
        typecheck.is_bool(useAuthPassphraseAsPrivPassphrase, AssertionError)
        typecheck.is_bool(havePrivPassphrase, AssertionError)
        typecheck.is_string(privPassphrase, AssertionError)

        self.enabled = enabled
        self.secLevel = secLevel
        self.authProtocol = authProtocol
        self.usePasswordAsAuthPassphrase = usePasswordAsAuthPassphrase
        self.haveAuthPassphrase = haveAuthPassphrase
        self.authPassphrase = authPassphrase
        self.privProtocol = privProtocol
        self.useAuthPassphraseAsPrivPassphrase = useAuthPassphraseAsPrivPassphrase
        self.havePrivPassphrase = havePrivPassphrase
        self.privPassphrase = privPassphrase

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            secLevel = raritan.rpc.usermgmt.SnmpV3SecLevel.decode(json['secLevel']),
            authProtocol = raritan.rpc.usermgmt.SnmpV3AuthProto.decode(json['authProtocol']),
            usePasswordAsAuthPassphrase = json['usePasswordAsAuthPassphrase'],
            haveAuthPassphrase = json['haveAuthPassphrase'],
            authPassphrase = json['authPassphrase'],
            privProtocol = raritan.rpc.usermgmt.SnmpV3PrivProto.decode(json['privProtocol']),
            useAuthPassphraseAsPrivPassphrase = json['useAuthPassphraseAsPrivPassphrase'],
            havePrivPassphrase = json['havePrivPassphrase'],
            privPassphrase = json['privPassphrase'],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['secLevel'] = raritan.rpc.usermgmt.SnmpV3SecLevel.encode(self.secLevel)
        json['authProtocol'] = raritan.rpc.usermgmt.SnmpV3AuthProto.encode(self.authProtocol)
        json['usePasswordAsAuthPassphrase'] = self.usePasswordAsAuthPassphrase
        json['haveAuthPassphrase'] = self.haveAuthPassphrase
        json['authPassphrase'] = self.authPassphrase
        json['privProtocol'] = raritan.rpc.usermgmt.SnmpV3PrivProto.encode(self.privProtocol)
        json['useAuthPassphraseAsPrivPassphrase'] = self.useAuthPassphraseAsPrivPassphrase
        json['havePrivPassphrase'] = self.havePrivPassphrase
        json['privPassphrase'] = self.privPassphrase
        return json

# structure
class AuxInfo(Structure):
    idlType = "usermgmt.AuxInfo:1.0.0"
    elements = ["fullname", "telephone", "eMail"]

    def __init__(self, fullname, telephone, eMail):
        typecheck.is_string(fullname, AssertionError)
        typecheck.is_string(telephone, AssertionError)
        typecheck.is_string(eMail, AssertionError)

        self.fullname = fullname
        self.telephone = telephone
        self.eMail = eMail

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            fullname = json['fullname'],
            telephone = json['telephone'],
            eMail = json['eMail'],
        )
        return obj

    def encode(self):
        json = {}
        json['fullname'] = self.fullname
        json['telephone'] = self.telephone
        json['eMail'] = self.eMail
        return json

# enumeration
class TemperatureEnum(Enumeration):
    idlType = "usermgmt.TemperatureEnum:1.0.0"
    values = ["DEG_C", "DEG_F"]

TemperatureEnum.DEG_C = TemperatureEnum(0)
TemperatureEnum.DEG_F = TemperatureEnum(1)

# enumeration
class LengthEnum(Enumeration):
    idlType = "usermgmt.LengthEnum:1.0.0"
    values = ["METER", "FEET"]

LengthEnum.METER = LengthEnum(0)
LengthEnum.FEET = LengthEnum(1)

# enumeration
class PressureEnum(Enumeration):
    idlType = "usermgmt.PressureEnum:1.0.0"
    values = ["PASCAL", "PSI"]

PressureEnum.PASCAL = PressureEnum(0)
PressureEnum.PSI = PressureEnum(1)

# structure
class Preferences(Structure):
    idlType = "usermgmt.Preferences:1.0.0"
    elements = ["temperatureUnit", "lengthUnit", "pressureUnit"]

    def __init__(self, temperatureUnit, lengthUnit, pressureUnit):
        typecheck.is_enum(temperatureUnit, raritan.rpc.usermgmt.TemperatureEnum, AssertionError)
        typecheck.is_enum(lengthUnit, raritan.rpc.usermgmt.LengthEnum, AssertionError)
        typecheck.is_enum(pressureUnit, raritan.rpc.usermgmt.PressureEnum, AssertionError)

        self.temperatureUnit = temperatureUnit
        self.lengthUnit = lengthUnit
        self.pressureUnit = pressureUnit

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            temperatureUnit = raritan.rpc.usermgmt.TemperatureEnum.decode(json['temperatureUnit']),
            lengthUnit = raritan.rpc.usermgmt.LengthEnum.decode(json['lengthUnit']),
            pressureUnit = raritan.rpc.usermgmt.PressureEnum.decode(json['pressureUnit']),
        )
        return obj

    def encode(self):
        json = {}
        json['temperatureUnit'] = raritan.rpc.usermgmt.TemperatureEnum.encode(self.temperatureUnit)
        json['lengthUnit'] = raritan.rpc.usermgmt.LengthEnum.encode(self.lengthUnit)
        json['pressureUnit'] = raritan.rpc.usermgmt.PressureEnum.encode(self.pressureUnit)
        return json

# structure
class UserInfo(Structure):
    idlType = "usermgmt.UserInfo:2.0.0"
    elements = ["enabled", "locked", "blocked", "needPasswordChange", "auxInfo", "snmpV3Settings", "sshPublicKey", "preferences", "roleIds"]

    def __init__(self, enabled, locked, blocked, needPasswordChange, auxInfo, snmpV3Settings, sshPublicKey, preferences, roleIds):
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_bool(locked, AssertionError)
        typecheck.is_bool(blocked, AssertionError)
        typecheck.is_bool(needPasswordChange, AssertionError)
        typecheck.is_struct(auxInfo, raritan.rpc.usermgmt.AuxInfo, AssertionError)
        typecheck.is_struct(snmpV3Settings, raritan.rpc.usermgmt.SnmpV3Settings, AssertionError)
        typecheck.is_string(sshPublicKey, AssertionError)
        typecheck.is_struct(preferences, raritan.rpc.usermgmt.Preferences, AssertionError)
        for x0 in roleIds:
            typecheck.is_int(x0, AssertionError)

        self.enabled = enabled
        self.locked = locked
        self.blocked = blocked
        self.needPasswordChange = needPasswordChange
        self.auxInfo = auxInfo
        self.snmpV3Settings = snmpV3Settings
        self.sshPublicKey = sshPublicKey
        self.preferences = preferences
        self.roleIds = roleIds

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            enabled = json['enabled'],
            locked = json['locked'],
            blocked = json['blocked'],
            needPasswordChange = json['needPasswordChange'],
            auxInfo = raritan.rpc.usermgmt.AuxInfo.decode(json['auxInfo'], agent),
            snmpV3Settings = raritan.rpc.usermgmt.SnmpV3Settings.decode(json['snmpV3Settings'], agent),
            sshPublicKey = json['sshPublicKey'],
            preferences = raritan.rpc.usermgmt.Preferences.decode(json['preferences'], agent),
            roleIds = [x0 for x0 in json['roleIds']],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['locked'] = self.locked
        json['blocked'] = self.blocked
        json['needPasswordChange'] = self.needPasswordChange
        json['auxInfo'] = raritan.rpc.usermgmt.AuxInfo.encode(self.auxInfo)
        json['snmpV3Settings'] = raritan.rpc.usermgmt.SnmpV3Settings.encode(self.snmpV3Settings)
        json['sshPublicKey'] = self.sshPublicKey
        json['preferences'] = raritan.rpc.usermgmt.Preferences.encode(self.preferences)
        json['roleIds'] = [x0 for x0 in self.roleIds]
        return json

# structure
class UserCapabilities(Structure):
    idlType = "usermgmt.UserCapabilities:1.0.0"
    elements = ["canSetPassword", "canSetPreferences"]

    def __init__(self, canSetPassword, canSetPreferences):
        typecheck.is_bool(canSetPassword, AssertionError)
        typecheck.is_bool(canSetPreferences, AssertionError)

        self.canSetPassword = canSetPassword
        self.canSetPreferences = canSetPreferences

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            canSetPassword = json['canSetPassword'],
            canSetPreferences = json['canSetPreferences'],
        )
        return obj

    def encode(self):
        json = {}
        json['canSetPassword'] = self.canSetPassword
        json['canSetPreferences'] = self.canSetPreferences
        return json

# interface
class User(Interface):
    idlType = "usermgmt.User:2.0.0"

    ERR_PASSWORD_UNCHANGED = 1

    ERR_PASSWORD_EMPTY = 2

    ERR_PASSWORD_TOO_SHORT = 3

    ERR_PASSWORD_TOO_LONG = 4

    ERR_PASSWORD_CTRL_CHARS = 5

    ERR_PASSWORD_NEED_LOWER = 6

    ERR_PASSWORD_NEED_UPPER = 7

    ERR_PASSWORD_NEED_NUMERIC = 8

    ERR_PASSWORD_NEED_SPECIAL = 9

    ERR_PASSWORD_IN_HISTORY = 10

    ERR_PASSWORD_TOO_SHORT_FOR_SNMP = 11

    ERR_INVALID_ARGUMENT = 12

    ERR_WRONG_PASSWORD = 13

    ERR_SSH_PUBKEY_DATA_TOO_LARGE = 14

    ERR_SSH_PUBKEY_INVALID = 15

    ERR_SSH_PUBKEY_NOT_SUPPORTED = 16

    ERR_SSH_RSA_PUBKEY_TOO_SHORT = 17

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.usermgmt.UserInfo.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.usermgmt.UserInfo, DecodeException)
            return _ret_

    class _setAccountPassword(Interface.Method):
        name = 'setAccountPassword'

        @staticmethod
        def encode(password):
            typecheck.is_string(password, AssertionError)
            args = {}
            args['password'] = password
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _updateAccountFull(Interface.Method):
        name = 'updateAccountFull'

        @staticmethod
        def encode(password, info):
            typecheck.is_string(password, AssertionError)
            typecheck.is_struct(info, raritan.rpc.usermgmt.UserInfo, AssertionError)
            args = {}
            args['password'] = password
            args['info'] = raritan.rpc.usermgmt.UserInfo.encode(info)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getInfoAndPrivileges(Interface.Method):
        name = 'getInfoAndPrivileges'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            info = raritan.rpc.usermgmt.UserInfo.decode(rsp['info'], agent)
            privileges = [raritan.rpc.usermgmt.Role.Privilege.decode(x0, agent) for x0 in rsp['privileges']]
            typecheck.is_struct(info, raritan.rpc.usermgmt.UserInfo, DecodeException)
            for x0 in privileges:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.Role.Privilege, DecodeException)
            return (info, privileges)

    class _setPreferences(Interface.Method):
        name = 'setPreferences'

        @staticmethod
        def encode(prefs):
            typecheck.is_struct(prefs, raritan.rpc.usermgmt.Preferences, AssertionError)
            args = {}
            args['prefs'] = raritan.rpc.usermgmt.Preferences.encode(prefs)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getCapabilities(Interface.Method):
        name = 'getCapabilities'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.usermgmt.UserCapabilities.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.usermgmt.UserCapabilities, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(User, self).__init__(target, agent)
        self.getInfo = User._getInfo(self)
        self.setAccountPassword = User._setAccountPassword(self)
        self.updateAccountFull = User._updateAccountFull(self)
        self.getInfoAndPrivileges = User._getInfoAndPrivileges(self)
        self.setPreferences = User._setPreferences(self)
        self.getCapabilities = User._getCapabilities(self)

#
# Section generated by IdlC from "UserManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.usermgmt


# structure
class Account(Structure):
    idlType = "usermgmt.Account:2.0.0"
    elements = ["name", "info"]

    def __init__(self, name, info):
        typecheck.is_string(name, AssertionError)
        typecheck.is_struct(info, raritan.rpc.usermgmt.UserInfo, AssertionError)

        self.name = name
        self.info = info

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            name = json['name'],
            info = raritan.rpc.usermgmt.UserInfo.decode(json['info'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['name'] = self.name
        json['info'] = raritan.rpc.usermgmt.UserInfo.encode(self.info)
        return json

# value object
class AccountEvent(raritan.rpc.event.UserEvent):
    idlType = "usermgmt.AccountEvent:1.0.0"

    def __init__(self, username, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.AccountEvent, self).__init__(actUserName, actIpAddr, source)
        typecheck.is_string(username, AssertionError)

        self.username = username

    def encode(self):
        json = super(raritan.rpc.usermgmt.AccountEvent, self).encode()
        json['username'] = self.username
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            username = json['username'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["username"]
        elements = elements + super(raritan.rpc.usermgmt.AccountEvent, self).listElements()
        return elements

# value object
class AccountAdded(AccountEvent):
    idlType = "usermgmt.AccountAdded:1.0.0"

    def __init__(self, username, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.AccountAdded, self).__init__(username, actUserName, actIpAddr, source)

    def encode(self):
        json = super(raritan.rpc.usermgmt.AccountAdded, self).encode()
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            # for usermgmt.AccountEvent
            username = json['username'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = []
        elements = elements + super(raritan.rpc.usermgmt.AccountAdded, self).listElements()
        return elements

# value object
class AccountRenamed(AccountEvent):
    idlType = "usermgmt.AccountRenamed:1.0.0"

    def __init__(self, newUsername, username, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.AccountRenamed, self).__init__(username, actUserName, actIpAddr, source)
        typecheck.is_string(newUsername, AssertionError)

        self.newUsername = newUsername

    def encode(self):
        json = super(raritan.rpc.usermgmt.AccountRenamed, self).encode()
        json['newUsername'] = self.newUsername
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            newUsername = json['newUsername'],
            # for usermgmt.AccountEvent
            username = json['username'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["newUsername"]
        elements = elements + super(raritan.rpc.usermgmt.AccountRenamed, self).listElements()
        return elements

# value object
class AccountRemoved(AccountEvent):
    idlType = "usermgmt.AccountRemoved:1.0.0"

    def __init__(self, username, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.AccountRemoved, self).__init__(username, actUserName, actIpAddr, source)

    def encode(self):
        json = super(raritan.rpc.usermgmt.AccountRemoved, self).encode()
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            # for usermgmt.AccountEvent
            username = json['username'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = []
        elements = elements + super(raritan.rpc.usermgmt.AccountRemoved, self).listElements()
        return elements

# value object
class PasswordChanged(AccountEvent):
    idlType = "usermgmt.PasswordChanged:1.0.0"

    def __init__(self, username, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.PasswordChanged, self).__init__(username, actUserName, actIpAddr, source)

    def encode(self):
        json = super(raritan.rpc.usermgmt.PasswordChanged, self).encode()
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            # for usermgmt.AccountEvent
            username = json['username'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = []
        elements = elements + super(raritan.rpc.usermgmt.PasswordChanged, self).listElements()
        return elements

# value object
class AccountChanged(AccountEvent):
    idlType = "usermgmt.AccountChanged:2.0.0"

    def __init__(self, oldSettings, newSettings, username, actUserName, actIpAddr, source):
        super(raritan.rpc.usermgmt.AccountChanged, self).__init__(username, actUserName, actIpAddr, source)
        typecheck.is_struct(oldSettings, raritan.rpc.usermgmt.UserInfo, AssertionError)
        typecheck.is_struct(newSettings, raritan.rpc.usermgmt.UserInfo, AssertionError)

        self.oldSettings = oldSettings
        self.newSettings = newSettings

    def encode(self):
        json = super(raritan.rpc.usermgmt.AccountChanged, self).encode()
        json['oldSettings'] = raritan.rpc.usermgmt.UserInfo.encode(self.oldSettings)
        json['newSettings'] = raritan.rpc.usermgmt.UserInfo.encode(self.newSettings)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            oldSettings = raritan.rpc.usermgmt.UserInfo.decode(json['oldSettings'], agent),
            newSettings = raritan.rpc.usermgmt.UserInfo.decode(json['newSettings'], agent),
            # for usermgmt.AccountEvent
            username = json['username'],
            # for event.UserEvent
            actUserName = json['actUserName'],
            actIpAddr = json['actIpAddr'],
            # for idl.Event
            source = Interface.decode(json['source'], agent),
        )
        return obj

    def listElements(self):
        elements = ["oldSettings", "newSettings"]
        elements = elements + super(raritan.rpc.usermgmt.AccountChanged, self).listElements()
        return elements

# interface
class UserManager(Interface):
    idlType = "usermgmt.UserManager:2.0.0"

    ERR_USER_DOESNT_EXIST = 1

    ERR_USER_NOT_DELETABLE = 2

    ERR_USER_ALREADY_EXISTS = 1

    ERR_MAX_USERS_REACHED = 2

    ERR_PASSWORD_TOO_SHORT_FOR_SNMP = 3

    ERR_INVALID_VALUE = 4

    ERR_PASSWORD_EMPTY = 5

    ERR_PASSWORD_TOO_SHORT = 6

    ERR_PASSWORD_TOO_LONG = 7

    ERR_PASSWORD_CTRL_CHARS = 8

    ERR_PASSWORD_NEED_LOWER = 9

    ERR_PASSWORD_NEED_UPPER = 10

    ERR_PASSWORD_NEED_NUMERIC = 11

    ERR_PASSWORD_NEED_SPECIAL = 12

    ERR_SSH_PUBKEY_DATA_TOO_LARGE = 14

    ERR_SSH_PUBKEY_INVALID = 15

    ERR_SSH_PUBKEY_NOT_SUPPORTED = 16

    ERR_SSH_RSA_PUBKEY_TOO_SHORT = 17

    ERR_USERNAME_INVALID = 18

    ERR_NEW_USER_ALREADY_EXISTS = 19

    class _getAccountNames(Interface.Method):
        name = 'getAccountNames'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _createAccount(Interface.Method):
        name = 'createAccount'

        @staticmethod
        def encode(username, password):
            typecheck.is_string(username, AssertionError)
            typecheck.is_string(password, AssertionError)
            args = {}
            args['username'] = username
            args['password'] = password
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _renameAccount(Interface.Method):
        name = 'renameAccount'

        @staticmethod
        def encode(username, newUsername):
            typecheck.is_string(username, AssertionError)
            typecheck.is_string(newUsername, AssertionError)
            args = {}
            args['username'] = username
            args['newUsername'] = newUsername
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _deleteAccount(Interface.Method):
        name = 'deleteAccount'

        @staticmethod
        def encode(username):
            typecheck.is_string(username, AssertionError)
            args = {}
            args['username'] = username
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getAllAccounts(Interface.Method):
        name = 'getAllAccounts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.usermgmt.Account.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.Account, DecodeException)
            return _ret_

    class _createAccountFull(Interface.Method):
        name = 'createAccountFull'

        @staticmethod
        def encode(username, password, info):
            typecheck.is_string(username, AssertionError)
            typecheck.is_string(password, AssertionError)
            typecheck.is_struct(info, raritan.rpc.usermgmt.UserInfo, AssertionError)
            args = {}
            args['username'] = username
            args['password'] = password
            args['info'] = raritan.rpc.usermgmt.UserInfo.encode(info)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getAccountsByRole(Interface.Method):
        name = 'getAccountsByRole'

        @staticmethod
        def encode(roleName):
            typecheck.is_string(roleName, AssertionError)
            args = {}
            args['roleName'] = roleName
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.usermgmt.Account.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.usermgmt.Account, DecodeException)
            return _ret_

    class _getDefaultPreferences(Interface.Method):
        name = 'getDefaultPreferences'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.usermgmt.Preferences.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.usermgmt.Preferences, DecodeException)
            return _ret_

    class _setDefaultPreferences(Interface.Method):
        name = 'setDefaultPreferences'

        @staticmethod
        def encode(prefs):
            typecheck.is_struct(prefs, raritan.rpc.usermgmt.Preferences, AssertionError)
            args = {}
            args['prefs'] = raritan.rpc.usermgmt.Preferences.encode(prefs)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(UserManager, self).__init__(target, agent)
        self.getAccountNames = UserManager._getAccountNames(self)
        self.createAccount = UserManager._createAccount(self)
        self.renameAccount = UserManager._renameAccount(self)
        self.deleteAccount = UserManager._deleteAccount(self)
        self.getAllAccounts = UserManager._getAllAccounts(self)
        self.createAccountFull = UserManager._createAccountFull(self)
        self.getAccountsByRole = UserManager._getAccountsByRole(self)
        self.getDefaultPreferences = UserManager._getDefaultPreferences(self)
        self.setDefaultPreferences = UserManager._setDefaultPreferences(self)
