/* Generated by re2c */
// re2c $INPUT -o $OUTPUT --loop-switch -i
#include <assert.h>
#include <stdlib.h>
#include <string.h>

// expect a string without terminating null
static int lex(const char *str, unsigned int len)
{
    const char *cur = str, *lim = str + len;
    int count = 0;

loop:
    
{
	char yych;
	unsigned int yystate = 0;
	for (;;) {
		switch (yystate) {
			case 0:
				yych = cur < lim ? *cur : 0;
				++cur;
				switch (yych) {
					case 0x00:
						yystate = 1;
						continue;
					case ' ':
						yystate = 3;
						continue;
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
					case 'g':
					case 'h':
					case 'i':
					case 'j':
					case 'k':
					case 'l':
					case 'm':
					case 'n':
					case 'o':
					case 'p':
					case 'q':
					case 'r':
					case 's':
					case 't':
					case 'u':
					case 'v':
					case 'w':
					case 'x':
					case 'y':
					case 'z':
						yystate = 5;
						continue;
					default:
						yystate = 2;
						continue;
				}
			case 1:
				{ return count; }
			case 2:
				{ return -1; }
			case 3:
				yych = cur < lim ? *cur : 0;
				switch (yych) {
					case ' ':
						++cur;
						yystate = 3;
						continue;
					default:
						yystate = 4;
						continue;
				}
			case 4:
				{ goto loop; }
			case 5:
				yych = cur < lim ? *cur : 0;
				switch (yych) {
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
					case 'g':
					case 'h':
					case 'i':
					case 'j':
					case 'k':
					case 'l':
					case 'm':
					case 'n':
					case 'o':
					case 'p':
					case 'q':
					case 'r':
					case 's':
					case 't':
					case 'u':
					case 'v':
					case 'w':
					case 'x':
					case 'y':
					case 'z':
						++cur;
						yystate = 5;
						continue;
					default:
						yystate = 6;
						continue;
				}
			case 6:
				{ ++count; goto loop; }
		}
	}
}

}

// make a copy of the string without terminating null
static void test(const char *str, unsigned int len, int res)
{
    char *s = (char*) malloc(len);
    memcpy(s, str, len);
    int r = lex(s, len);
    free(s);
    assert(r == res);
}

#define TEST(s, r) test(s, sizeof(s) - 1, r)
int main()
{
    TEST("", 0);
    TEST("one two three ", 3);
    TEST("f0ur", -1);
    return 0;
}
